/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zyportal.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.zyportal.mapper.ZyPortalMapper;
import com.ejianc.business.zyportal.service.IZyPortalService;
import com.ejianc.business.zyportal.vo.PortalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="zyPortalService")
public class ZyPortalServiceImpl
implements IZyPortalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${database.dbtype:mysql}")
    private String dbType;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ZyPortalMapper zyPortalMapper;

    @Override
    public JSONObject getProjectInfo() {
        JSONObject result = new JSONObject();
        List orgIdList = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgIdList", orgIdList);
        params.put("thisYear", "thisYear");
        params.put("dbType", this.dbType);
        Integer thisYearProjectNum = this.zyPortalMapper.getProjectNum(params);
        result.put("thisYearProjectNum", (Object)thisYearProjectNum);
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("orgIdList", orgIdList);
        params2.put("status", "1");
        params2.put("dbType", this.dbType);
        Integer notStartedProjectNum = this.zyPortalMapper.getProjectNum(params2);
        result.put("notStartedProjectNum", (Object)notStartedProjectNum);
        HashMap<String, Object> params3 = new HashMap<String, Object>();
        params3.put("orgIdList", orgIdList);
        params3.put("status", "2");
        params3.put("dbType", this.dbType);
        Integer buildProjectNum = this.zyPortalMapper.getProjectNum(params3);
        result.put("buildProjectNum", (Object)buildProjectNum);
        HashMap<String, Object> params4 = new HashMap<String, Object>();
        params4.put("orgIdList", orgIdList);
        params4.put("status", "5");
        params4.put("dbType", this.dbType);
        Integer acceptanceProjectNum = this.zyPortalMapper.getProjectNum(params4);
        result.put("acceptanceProjectNum", (Object)acceptanceProjectNum);
        HashMap<String, Object> params5 = new HashMap<String, Object>();
        params5.put("orgIdList", orgIdList);
        params5.put("status", "3");
        params5.put("dbType", this.dbType);
        Integer finishProjectNum = this.zyPortalMapper.getProjectNum(params5);
        result.put("finishProjectNum", (Object)finishProjectNum);
        HashMap<String, Object> params6 = new HashMap<String, Object>();
        params6.put("orgIdList", orgIdList);
        params6.put("status", "4");
        params6.put("dbType", this.dbType);
        Integer stopProjectNum = this.zyPortalMapper.getProjectNum(params6);
        result.put("stopProjectNum", (Object)stopProjectNum);
        HashMap<String, Object> params7 = new HashMap<String, Object>();
        params7.put("orgIdList", orgIdList);
        params7.put("status", "5");
        params7.put("dbType", this.dbType);
        Integer allProjectNum = this.zyPortalMapper.getProjectNum(params7);
        result.put("allProjectNum", (Object)allProjectNum);
        return result;
    }

    @Override
    public JSONObject getProductionCapacity() {
        HashMap resultMap = new HashMap();
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(true);
        ArrayList<Long> orgIdsList = new ArrayList<Long>();
        if (orgMap != null && orgMap.size() > 0) {
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                resultMap.put(aLong, new HashMap());
            }
        }
        LocalDate today = LocalDate.now();
        ArrayList<String> monthList = new ArrayList<String>();
        ArrayList<String> monthSqlList = new ArrayList<String>();
        String beginTime = "";
        String endTime = "";
        for (int i = 6; i > 0; --i) {
            LocalDate month = today.minusMonths(i);
            monthList.add(month.format(DateTimeFormatter.ofPattern("MM")));
            monthSqlList.add(month.format(DateTimeFormatter.ofPattern("yyyy-MM")));
        }
        int dayOfMonth = today.getDayOfMonth();
        if (dayOfMonth >= 25) {
            monthList.remove(0);
            String currentMonthStr = today.format(DateTimeFormatter.ofPattern("MM"));
            monthList.add(currentMonthStr);
            monthSqlList.remove(0);
            Iterator currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            monthSqlList.add((String)((Object)currentMonthStr1));
            LocalDate nextMonth = today.minusMonths(-1L);
            String nextMonthStr = nextMonth.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = nextMonthStr + "-01 00:00:00";
        } else {
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = currentMonthStr1 + "-01 00:00:00";
        }
        beginTime = (String)monthSqlList.get(0) + "-01 00:00:00";
        LinkedList<String> legendData = new LinkedList<String>();
        for (String month : monthList) {
            legendData.add(month);
        }
        for (Long orgId : resultMap.keySet()) {
            HashMap<String, BigDecimal> v = new HashMap<String, BigDecimal>();
            for (String month : monthSqlList) {
                v.put(month, new BigDecimal(0));
            }
            resultMap.put(orgId, v);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        LinkedHashMap<Long, String> innerCodeMap = new LinkedHashMap<Long, String>();
        CommonResponse orgResponse = this.orgApi.findChildrenByParentIds(orgIdsList);
        if (orgResponse.isSuccess()) {
            for (OrgVO vo : (List)orgResponse.getData()) {
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(), vo.getInnerCode());
            }
        }
        HashMap<String, Object> paramEfficiency = new HashMap<String, Object>();
        paramEfficiency.put("tenantId", InvocationInfoProxy.getTenantid());
        paramEfficiency.put("beginTime", beginTime);
        paramEfficiency.put("endTime", endTime);
        paramEfficiency.put("orgIds", orgIds);
        paramEfficiency.put("dbType", this.dbType);
        List<ProductionEntity> productionList = this.zyPortalMapper.getProductionCapacity(paramEfficiency);
        for (ProductionEntity vo : productionList) {
            if (vo.getFinishTaxMny() == null || !innerCodeMap.containsKey(vo.getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(vo.getOrgId());
            for (Long orgId : resultMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                Map m = (Map)resultMap.get(orgId);
                for (String month : m.keySet()) {
                    BigDecimal va = (BigDecimal)m.get(month);
                    if (!vo.getBillCode().equals(month)) continue;
                    va = va.add(vo.getFinishTaxMny());
                    m.put(month, va);
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray data = new JSONArray();
        for (Long orgId : resultMap.keySet()) {
            String orgName = orgMap.get(orgId).getName();
            JSONObject dataJson = new JSONObject();
            dataJson.put("name", (Object)orgName);
            dataJson.put("data", ((Map)resultMap.get(orgId)).entrySet());
            data.add((Object)dataJson);
        }
        jsonObject.put("data", (Object)data);
        jsonObject.put("legendData", legendData);
        return jsonObject;
    }

    @Override
    public JSONObject getBusinessSegment() {
        Object num;
        HashMap<Long, List<Long>> defMap = new HashMap<Long, List<Long>>();
        HashMap<Long, DefdocDetailVO> defDetailMap = new HashMap<Long, DefdocDetailVO>();
        HashMap<Long, Long> childParentMap = new HashMap<Long, Long>();
        this.getBusinessSegmentDefdoc(defMap, defDetailMap, childParentMap);
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList orgIds = new ArrayList();
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds", orgIds);
        List<PortalVO> list = this.zyPortalMapper.getBusinessSegment(params);
        HashMap<Long, PortalVO> reMap = new HashMap<Long, PortalVO>();
        for (Long defId : defMap.keySet()) {
            PortalVO vo = new PortalVO();
            vo.setContractMny(new BigDecimal(0));
            vo.setNum(0);
            reMap.put(defId, vo);
        }
        for (PortalVO portalVO : list) {
            BigDecimal con;
            Long pDefId = (Long)childParentMap.get(portalVO.getId());
            PortalVO vo = (PortalVO)reMap.get(pDefId);
            num = (vo.getNum() != null ? vo.getNum() : 0) + (portalVO.getNum() != null ? portalVO.getNum() : 0);
            vo.setNum((Integer)num);
            if (vo.getContractMny() != null) {
                con = portalVO.getContractMny() != null ? portalVO.getContractMny() : new BigDecimal(0);
                con = con.add(vo.getContractMny());
                vo.setContractMny(con);
                continue;
            }
            con = portalVO.getContractMny() != null ? portalVO.getContractMny() : new BigDecimal(0);
            vo.setContractMny(con);
        }
        JSONArray numResult = new JSONArray();
        JSONArray moneyResult = new JSONArray();
        for (Long defId : reMap.keySet()) {
            num = new JSONObject();
            num.put("name", (Object)((DefdocDetailVO)defDetailMap.get(defId)).getName());
            num.put("value", (Object)((PortalVO)reMap.get(defId)).getNum());
            numResult.add(num);
            JSONObject money = new JSONObject();
            money.put("name", (Object)((DefdocDetailVO)defDetailMap.get(defId)).getName());
            money.put("value", (Object)((PortalVO)reMap.get(defId)).getContractMny());
            moneyResult.add((Object)money);
        }
        JSONObject re = new JSONObject();
        re.put("numData", (Object)numResult);
        re.put("contractMnyData", (Object)moneyResult);
        return re;
    }

    @Override
    public JSONObject getCompanyProjectInfo() {
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(false);
        HashMap<Long, Integer> numMap = new HashMap<Long, Integer>();
        HashMap<Long, BigDecimal> moneyMap = new HashMap<Long, BigDecimal>();
        ArrayList<Long> orgIdsList = new ArrayList<Long>();
        if (orgMap != null && orgMap.size() > 0) {
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                numMap.put(aLong, 0);
                moneyMap.put(aLong, new BigDecimal(0));
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        LinkedHashMap<Long, String> innerCodeMap = new LinkedHashMap<Long, String>();
        CommonResponse orgResponse = this.orgApi.findChildrenByParentIds(orgIdsList);
        if (orgResponse.isSuccess()) {
            for (OrgVO vo : (List)orgResponse.getData()) {
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(), vo.getInnerCode());
            }
        }
        HashMap<String, Object> paramEfficiency = new HashMap<String, Object>();
        paramEfficiency.put("tenantId", InvocationInfoProxy.getTenantid());
        paramEfficiency.put("orgIds", orgIds);
        List<PortalVO> productionList = this.zyPortalMapper.getCompanyProjectInfo(paramEfficiency);
        for (PortalVO vo : productionList) {
            if (!innerCodeMap.containsKey(vo.getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(vo.getOrgId());
            for (Long orgId : numMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                Integer m = (Integer)numMap.get(orgId);
                m = m + (vo.getNum() != null ? vo.getNum() : 0);
                numMap.put(orgId, m);
                BigDecimal money = (BigDecimal)moneyMap.get(orgId);
                if (vo.getContractMny() != null) {
                    money = money.add(vo.getContractMny());
                }
                moneyMap.put(orgId, money);
            }
        }
        JSONObject re = new JSONObject();
        LinkedList<String> legendData = new LinkedList<String>();
        LinkedList numData = new LinkedList();
        LinkedList contractMnyData = new LinkedList();
        for (Long orgId : numMap.keySet()) {
            legendData.add(orgMap.get(orgId).getName());
            numData.add(numMap.get(orgId));
            contractMnyData.add(moneyMap.get(orgId));
        }
        re.put("legendData", legendData);
        re.put("numData", numData);
        re.put("contractMnyData", contractMnyData);
        return re;
    }

    @Override
    public JSONObject getProjectMoneyInterval() {
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList orgIds = new ArrayList();
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds", orgIds);
        PortalVO vo = this.zyPortalMapper.getProjectMoneyInterval(params);
        LinkedList<String> legendData = new LinkedList<String>();
        LinkedList<Integer> numData = new LinkedList<Integer>();
        legendData.push("300\u4e07\u4ee5\u4e0b");
        numData.push(vo.getNum1() != null ? vo.getNum1() : 0);
        legendData.push("300-500\u4e07");
        numData.push(vo.getNum2() != null ? vo.getNum2() : 0);
        legendData.push("500-1000\u4e07");
        numData.push(vo.getNum3() != null ? vo.getNum3() : 0);
        legendData.push("1000\u4e07\u4ee5\u4e0a");
        numData.push(vo.getNum4() != null ? vo.getNum4() : 0);
        JSONObject re = new JSONObject();
        re.put("legendData", legendData);
        re.put("numData", numData);
        return re;
    }

    @Override
    public JSONObject getProjectProfitMarginInterval() {
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList orgIds = new ArrayList();
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds", orgIds);
        PortalVO vo = this.zyPortalMapper.getProjectProfitMarginInterval(params);
        LinkedList<String> legendData = new LinkedList<String>();
        LinkedList<Integer> numData = new LinkedList<Integer>();
        legendData.push("20%\u4e07\u4ee5\u4e0b");
        numData.push(vo.getNum1() != null ? vo.getNum1() : 0);
        legendData.push("20%-30%\u4e07");
        numData.push(vo.getNum2() != null ? vo.getNum2() : 0);
        legendData.push("30%-40%\u4e07");
        numData.push(vo.getNum3() != null ? vo.getNum3() : 0);
        legendData.push("40%\u4e07\u4ee5\u4e0a");
        numData.push(vo.getNum4() != null ? vo.getNum4() : 0);
        JSONObject re = new JSONObject();
        re.put("legendData", legendData);
        re.put("numData", numData);
        return re;
    }

    @Override
    public JSONObject getProjectProcess() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        LinkedHashMap<Long, String> innerCodeMap = new LinkedHashMap<Long, String>();
        CommonResponse orgResponse = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (orgResponse.isSuccess()) {
            for (OrgVO vo : (List)orgResponse.getData()) {
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(), vo.getInnerCode());
            }
        }
        HashMap<String, Object> outputValueProgressParams = new HashMap<String, Object>();
        outputValueProgressParams.put("tenantId", InvocationInfoProxy.getTenantid());
        outputValueProgressParams.put("orgIds", orgIds);
        List<ProductionEntity> productionList = this.zyPortalMapper.getOutputValueProgress(outputValueProgressParams);
        HashMap<Long, ProductionEntity> productionMap = new HashMap<Long, ProductionEntity>();
        if (productionList != null && productionList.size() > 0) {
            for (ProductionEntity productionEntity : productionList) {
                productionMap.put(productionEntity.getProjectId(), productionEntity);
            }
        }
        HashMap<String, Object> projectParams = new HashMap<String, Object>();
        projectParams.put("tenantId", InvocationInfoProxy.getTenantid());
        projectParams.put("orgIds", orgIds);
        List<ProjectRegisterVO> projectList = this.zyPortalMapper.getProjectList(projectParams);
        HashMap<String, Object> completionAssessmentParams = new HashMap<String, Object>();
        completionAssessmentParams.put("tenantId", InvocationInfoProxy.getTenantid());
        completionAssessmentParams.put("orgIds", orgIds);
        List<PortalVO> completionAssessmentList = this.zyPortalMapper.getCompletionAssessment(completionAssessmentParams);
        HashMap<Long, PortalVO> completionAssessmentMap = new HashMap<Long, PortalVO>();
        if (completionAssessmentList != null && completionAssessmentList.size() > 0) {
            for (PortalVO vo : completionAssessmentList) {
                completionAssessmentMap.put(vo.getId(), vo);
            }
        }
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(true);
        LinkedHashMap<Long, Integer> normalProject = new LinkedHashMap<Long, Integer>();
        LinkedHashMap<Long, Integer> lagProject = new LinkedHashMap<Long, Integer>();
        LinkedHashMap<Long, Integer> seriouslyLagProject = new LinkedHashMap<Long, Integer>();
        LinkedList<Long> orgIdsList = new LinkedList<Long>();
        LinkedList<String> legendData = new LinkedList<String>();
        if (orgMap != null && orgMap.size() > 0) {
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                String orgName = orgMap.get(aLong).getName();
                legendData.add(orgName);
                normalProject.put(aLong, 0);
                lagProject.put(aLong, 0);
                seriouslyLagProject.put(aLong, 0);
            }
        }
        if (projectList != null && projectList.size() > 0) {
            for (ProjectRegisterVO pvo : projectList) {
                Long b;
                Long a;
                LocalDate finishDate;
                LocalDate startDate;
                LocalDate newDate;
                Date date;
                BigDecimal durationProcess = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)pvo.getStatus()) || "1".equals(pvo.getStatus()) || "2".equals(pvo.getStatus()) || "5".equals(pvo.getStatus()) || "4".equals(pvo.getStatus())) {
                    if (pvo.getStartDate() != null && pvo.getFinishDate() != null) {
                        date = new Date();
                        newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        a = ChronoUnit.DAYS.between(startDate, newDate) + 1L;
                        b = ChronoUnit.DAYS.between(startDate, finishDate) + 1L;
                        durationProcess = BigDecimal.valueOf(a / b * 100L, 4);
                    }
                } else if ("3".equals(pvo.getStatus()) && pvo.getStartDate() != null && pvo.getFinishDate() != null) {
                    date = new Date();
                    newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (completionAssessmentMap.get(pvo.getId()) != null) {
                        LocalDate createTime = ((PortalVO)completionAssessmentMap.get(pvo.getId())).getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        Long a2 = ChronoUnit.DAYS.between(startDate, createTime) + 1L;
                        Long b2 = ChronoUnit.DAYS.between(startDate, finishDate) + 1L;
                        durationProcess = BigDecimal.valueOf(a2 / b2 * 100L, 4);
                    } else {
                        a = ChronoUnit.DAYS.between(startDate, newDate) + 1L;
                        b = ChronoUnit.DAYS.between(startDate, finishDate) + 1L;
                        durationProcess = BigDecimal.valueOf(a / b * 100L, 4);
                    }
                }
                BigDecimal progressValue = new BigDecimal(0);
                if (productionMap.get(pvo.getId()) != null && ((ProductionEntity)((Object)productionMap.get(pvo.getId()))).getSumImageProgressHaveThis() != null) {
                    progressValue = ((ProductionEntity)((Object)productionMap.get(pvo.getId()))).getSumImageProgressHaveThis();
                }
                BigDecimal re = progressValue.subtract(durationProcess);
                if (!innerCodeMap.containsKey(pvo.getProjectDepartmentId())) continue;
                String innerCode = (String)innerCodeMap.get(pvo.getProjectDepartmentId());
                for (Long orgId : orgMap.keySet()) {
                    Integer n;
                    Integer n2;
                    Integer n3;
                    if (!innerCode.contains(orgId + "")) continue;
                    if (re.compareTo(new BigDecimal(-10)) >= 0) {
                        n2 = n3 = (Integer)normalProject.get(orgId);
                        n = n3 = Integer.valueOf(n3 + 1);
                        normalProject.put(orgId, n3);
                        continue;
                    }
                    if (re.compareTo(new BigDecimal(-20)) >= 0) {
                        n2 = n3 = (Integer)lagProject.get(orgId);
                        n = n3 = Integer.valueOf(n3 + 1);
                        lagProject.put(orgId, n3);
                        continue;
                    }
                    n2 = n3 = (Integer)seriouslyLagProject.get(orgId);
                    n = n3 = Integer.valueOf(n3 + 1);
                    seriouslyLagProject.put(orgId, n3);
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray data = new JSONArray();
        JSONObject normalJson = new JSONObject();
        normalJson.put("name", (Object)"\u6b63\u5e38\u9879\u76ee");
        normalJson.put("data", normalProject.entrySet());
        data.add((Object)normalJson);
        JSONObject lagJson = new JSONObject();
        lagJson.put("name", (Object)"\u6ede\u540e\u9879\u76ee");
        lagJson.put("data", lagProject.entrySet());
        data.add((Object)lagJson);
        JSONObject seriouslyLagJson = new JSONObject();
        seriouslyLagJson.put("name", (Object)"\u4e25\u91cd\u6ede\u540e");
        seriouslyLagJson.put("data", seriouslyLagProject.entrySet());
        data.add((Object)seriouslyLagJson);
        jsonObject.put("ladyList", (Object)data);
        jsonObject.put("legendData", legendData);
        return jsonObject;
    }

    @Override
    public JSONObject getCostStructure() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        LinkedHashMap<Long, String> innerCodeMap = new LinkedHashMap<Long, String>();
        CommonResponse orgResponse = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (orgResponse.isSuccess()) {
            for (OrgVO vo : (List)orgResponse.getData()) {
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(), vo.getInnerCode());
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("orgIds", orgIds);
        List<PortalVO> costStructureList = this.zyPortalMapper.getCostStructure(params);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (costStructureList != null && costStructureList.size() > 0) {
            for (PortalVO portalVO : costStructureList) {
                map.put(portalVO.getName(), portalVO.getContractMny());
            }
        }
        JSONObject re = new JSONObject();
        JSONArray list = new JSONArray();
        JSONObject rgf = new JSONObject();
        rgf.put("name", (Object)"\u4eba\u5de5\u8d39");
        rgf.put("value", map.get("rgf") != null ? map.get("rgf") : Integer.valueOf(0));
        list.add((Object)rgf);
        JSONObject clf = new JSONObject();
        clf.put("name", (Object)"\u6750\u6599\u8d39");
        clf.put("value", map.get("clf") != null ? map.get("clf") : Integer.valueOf(0));
        list.add((Object)clf);
        JSONObject sbf = new JSONObject();
        sbf.put("name", (Object)"\u8bbe\u5907\u8d39");
        sbf.put("value", map.get("sbf") != null ? map.get("sbf") : Integer.valueOf(0));
        list.add((Object)sbf);
        JSONObject qtzjfy = new JSONObject();
        qtzjfy.put("name", (Object)"\u5176\u4ed6\u76f4\u63a5\u8d39");
        qtzjfy.put("value", map.get("qtzjfy") != null ? map.get("qtzjfy") : Integer.valueOf(0));
        list.add((Object)qtzjfy);
        JSONObject wxfy = new JSONObject();
        wxfy.put("name", (Object)"\u5916\u534f\u8d39\u7528");
        wxfy.put("value", map.get("wxfy") != null ? map.get("wxfy") : Integer.valueOf(0));
        list.add((Object)wxfy);
        re.put("data", (Object)re);
        return re;
    }

    @Override
    public JSONObject getProcessCost() {
        LinkedHashMap<Long, OrgVO> orgMap = this.getOrgMap(false);
        HashMap<Long, Object> moneyMap = new HashMap<Long, Object>();
        HashMap<Long, Object> constructionCostMap = new HashMap<Long, Object>();
        HashMap<Long, Object> actualCostMap = new HashMap<Long, Object>();
        HashMap<Long, BigDecimal> costProcessMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> durationMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, Integer> pnumMap = new HashMap<Long, Integer>();
        ArrayList<Long> orgIdsList = new ArrayList<Long>();
        if (orgMap != null && orgMap.size() > 0) {
            for (Long aLong : orgMap.keySet()) {
                orgIdsList.add(aLong);
                moneyMap.put(aLong, new BigDecimal(0));
                constructionCostMap.put(aLong, new BigDecimal(0));
                actualCostMap.put(aLong, new BigDecimal(0));
                costProcessMap.put(aLong, new BigDecimal(0));
                durationMap.put(aLong, new BigDecimal(0));
                pnumMap.put(aLong, 0);
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        LinkedHashMap<Long, String> innerCodeMap = new LinkedHashMap<Long, String>();
        CommonResponse orgResponse = this.orgApi.findChildrenByParentIds(orgIdsList);
        if (orgResponse.isSuccess()) {
            for (OrgVO vo : (List)orgResponse.getData()) {
                orgIds.add(vo.getId());
                innerCodeMap.put(vo.getId(), vo.getInnerCode());
            }
        }
        HashMap<String, Object> projectMoneyParams = new HashMap<String, Object>();
        projectMoneyParams.put("tenantId", InvocationInfoProxy.getTenantid());
        projectMoneyParams.put("orgIds", orgIds);
        List<PortalVO> projectMoneyList = this.zyPortalMapper.getCompanyProjectInfo(projectMoneyParams);
        for (PortalVO vo : projectMoneyList) {
            if (!innerCodeMap.containsKey(vo.getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(vo.getOrgId());
            for (Long orgId : moneyMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                Object money = (BigDecimal)moneyMap.get(orgId);
                if (vo.getContractMny() != null) {
                    money = ((BigDecimal)money).add(vo.getContractMny());
                }
                moneyMap.put(orgId, money);
            }
        }
        HashMap<String, Object> constructionCostParams = new HashMap<String, Object>();
        constructionCostParams.put("tenantId", InvocationInfoProxy.getTenantid());
        constructionCostParams.put("orgIds", orgIds);
        List<PortalVO> constructionCostList = this.zyPortalMapper.getConstructionCost(constructionCostParams);
        for (PortalVO vo : constructionCostList) {
            if (!innerCodeMap.containsKey(vo.getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(vo.getOrgId());
            for (Long orgId : constructionCostMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                Object money = (BigDecimal)constructionCostMap.get(orgId);
                if (vo.getContractMny() != null) {
                    money = ((BigDecimal)money).add(vo.getContractMny());
                }
                constructionCostMap.put(orgId, money);
            }
        }
        HashMap<String, Object> materialParams = new HashMap<String, Object>();
        materialParams.put("tenantId", InvocationInfoProxy.getTenantid());
        materialParams.put("orgIds", orgIds);
        List<PortalVO> materialList = this.zyPortalMapper.getMaterialMoney(materialParams);
        for (PortalVO vo : materialList) {
            if (!innerCodeMap.containsKey(vo.getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(vo.getOrgId());
            for (Long orgId : actualCostMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                Object money = (BigDecimal)actualCostMap.get(orgId);
                if (vo.getContractMny() != null) {
                    money = ((BigDecimal)money).add(vo.getContractMny());
                }
                actualCostMap.put(orgId, money);
            }
        }
        HashMap<String, Object> otherParams = new HashMap<String, Object>();
        otherParams.put("tenantId", InvocationInfoProxy.getTenantid());
        otherParams.put("orgIds", orgIds);
        List<PortalVO> otherList = this.zyPortalMapper.getOtherMoney(otherParams);
        for (PortalVO vo : otherList) {
            if (!innerCodeMap.containsKey(vo.getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(vo.getOrgId());
            for (Long orgId : actualCostMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                Object money = (BigDecimal)actualCostMap.get(orgId);
                if (vo.getContractMny() != null) {
                    money = ((BigDecimal)money).add(vo.getContractMny());
                }
                actualCostMap.put(orgId, money);
            }
        }
        HashMap<String, Object> laborProcessParams = new HashMap<String, Object>();
        laborProcessParams.put("tenantId", InvocationInfoProxy.getTenantid());
        laborProcessParams.put("orgIds", orgIds);
        List<PortalVO> laborProcessList = this.zyPortalMapper.getLaborProcessMoney(laborProcessParams);
        HashMap<String, Object> laborFinishParams = new HashMap<String, Object>();
        laborFinishParams.put("tenantId", InvocationInfoProxy.getTenantid());
        laborFinishParams.put("orgIds", orgIds);
        List<PortalVO> laborFinishList = this.zyPortalMapper.getLaborFinishMoney(laborFinishParams);
        HashMap<Long, PortalVO> laborFinishMap = new HashMap<Long, PortalVO>();
        if (laborFinishList != null && laborFinishList.size() > 0) {
            for (PortalVO portalVO : laborFinishList) {
                laborFinishMap.put(portalVO.getId(), portalVO);
            }
        }
        ArrayList<Object> laborList = new ArrayList<Object>();
        if (laborProcessList != null && laborProcessList.size() > 0) {
            for (PortalVO portalVO : laborProcessList) {
                if (laborFinishMap.get(portalVO.getId()) != null) {
                    laborList.add(laborFinishMap.get(portalVO.getId()));
                    continue;
                }
                laborList.add(portalVO);
            }
        }
        for (Object vo : laborList) {
            if (!innerCodeMap.containsKey(((PortalVO)vo).getOrgId())) continue;
            String innerCode = (String)innerCodeMap.get(((PortalVO)vo).getOrgId());
            for (Long orgId : actualCostMap.keySet()) {
                if (!innerCode.contains(orgId + "")) continue;
                BigDecimal money = (BigDecimal)actualCostMap.get(orgId);
                if (((PortalVO)vo).getContractMny() != null) {
                    money = money.add(((PortalVO)vo).getContractMny());
                }
                actualCostMap.put(orgId, money);
            }
        }
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        for (Long orgId : constructionCostMap.keySet()) {
            BigDecimal constructionCost = (BigDecimal)constructionCostMap.get(orgId);
            BigDecimal actualCost = (BigDecimal)actualCostMap.get(orgId);
            if (constructionCost == null || actualCost == null) continue;
            BigDecimal r = actualCost.divide(constructionCost, mathContext).multiply(new BigDecimal(100));
            costProcessMap.put(orgId, r);
        }
        HashMap<String, Object> projectParams = new HashMap<String, Object>();
        projectParams.put("tenantId", InvocationInfoProxy.getTenantid());
        projectParams.put("orgIds", orgIds);
        List<ProjectRegisterVO> projectList = this.zyPortalMapper.getProjectList(projectParams);
        HashMap<String, Object> completionAssessmentParams = new HashMap<String, Object>();
        completionAssessmentParams.put("tenantId", InvocationInfoProxy.getTenantid());
        completionAssessmentParams.put("orgIds", orgIds);
        List<PortalVO> completionAssessmentList = this.zyPortalMapper.getCompletionAssessment(completionAssessmentParams);
        HashMap<Long, PortalVO> completionAssessmentMap = new HashMap<Long, PortalVO>();
        if (completionAssessmentList != null && completionAssessmentList.size() > 0) {
            for (PortalVO vo : completionAssessmentList) {
                completionAssessmentMap.put(vo.getId(), vo);
            }
        }
        if (projectList != null && projectList.size() > 0) {
            for (ProjectRegisterVO pvo : projectList) {
                Number b;
                Long a;
                LocalDate finishDate;
                LocalDate startDate;
                Object newDate;
                Date date;
                BigDecimal durationProcess = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)pvo.getStatus()) || "1".equals(pvo.getStatus()) || "2".equals(pvo.getStatus()) || "5".equals(pvo.getStatus()) || "4".equals(pvo.getStatus())) {
                    if (pvo.getStartDate() != null && pvo.getFinishDate() != null) {
                        date = new Date();
                        newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        a = ChronoUnit.DAYS.between(startDate, (Temporal)newDate) + 1L;
                        b = ChronoUnit.DAYS.between(startDate, finishDate) + 1L;
                        durationProcess = BigDecimal.valueOf(a / (Long)b * 100L, 4);
                    }
                } else if ("3".equals(pvo.getStatus()) && pvo.getStartDate() != null && pvo.getFinishDate() != null) {
                    date = new Date();
                    newDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    startDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    finishDate = pvo.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (completionAssessmentMap.get(pvo.getId()) != null) {
                        LocalDate createTime = ((PortalVO)completionAssessmentMap.get(pvo.getId())).getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        Long a2 = ChronoUnit.DAYS.between(startDate, createTime) + 1L;
                        Long b2 = ChronoUnit.DAYS.between(startDate, finishDate) + 1L;
                        durationProcess = BigDecimal.valueOf(a2 / b2 * 100L, 4);
                    } else {
                        a = ChronoUnit.DAYS.between(startDate, (Temporal)newDate) + 1L;
                        b = ChronoUnit.DAYS.between(startDate, finishDate) + 1L;
                        durationProcess = BigDecimal.valueOf(a / (Long)b * 100L, 4);
                    }
                }
                if (!innerCodeMap.containsKey(pvo.getProjectDepartmentId())) continue;
                String innerCode = (String)innerCodeMap.get(pvo.getProjectDepartmentId());
                for (Long orgId : orgMap.keySet()) {
                    if (!innerCode.contains(orgId + "")) continue;
                    BigDecimal duration = (BigDecimal)durationMap.get(orgId);
                    if (durationProcess != null) {
                        duration = duration.add(durationProcess);
                    }
                    durationMap.put(orgId, duration);
                    Integer n = (Integer)pnumMap.get(orgId);
                    b = n;
                    Integer n2 = n = Integer.valueOf(n + 1);
                    pnumMap.put(orgId, n);
                }
            }
        }
        for (Long orgId : durationMap.keySet()) {
            BigDecimal duration = (BigDecimal)durationMap.get(orgId);
            Integer num = (Integer)pnumMap.get(orgId);
            if (duration == null || num == null || num == 0) continue;
            BigDecimal r = duration.divide(BigDecimal.valueOf(num.intValue()), mathContext).multiply(new BigDecimal(100));
            durationMap.put(orgId, r);
        }
        JSONObject re = new JSONObject();
        LinkedList<String> legendData = new LinkedList<String>();
        LinkedList contractMnyData = new LinkedList();
        LinkedList constructionCostData = new LinkedList();
        LinkedList actualCostData = new LinkedList();
        LinkedList costProcessData = new LinkedList();
        LinkedList durationData = new LinkedList();
        for (Long orgId : moneyMap.keySet()) {
            legendData.add(orgMap.get(orgId).getName());
            contractMnyData.add(moneyMap.get(orgId));
            constructionCostData.add(constructionCostMap.get(orgId));
            actualCostData.add(actualCostMap.get(orgId));
            costProcessData.add(costProcessMap.get(orgId));
            durationData.add(durationMap.get(orgId));
        }
        re.put("legendData", legendData);
        re.put("contractMnyData", contractMnyData);
        re.put("constructionCostData", constructionCostData);
        re.put("actualCostData", actualCostData);
        re.put("costProcessData", costProcessData);
        re.put("durationData", durationData);
        return re;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private void getBusinessSegmentDefdoc(Map<Long, List<Long>> defMap, Map<Long, DefdocDetailVO> defDetailMap, Map<Long, Long> childParentMap) {
        CommonResponse defResponse = this.defdocApi.getDefDocByDefCode("zydx-businessSector");
        if (defResponse.isSuccess()) {
            List list = (List)defResponse.getData();
            for (DefdocDetailVO defdocDetailVO : list) {
                List<Object> second;
                defDetailMap.put(defdocDetailVO.getId(), defdocDetailVO);
                if (defdocDetailVO.getParentId() == null) continue;
                childParentMap.put(defdocDetailVO.getId(), defdocDetailVO.getParentId());
                if (defMap.get(defdocDetailVO.getParentId()) != null) {
                    second = defMap.get(defdocDetailVO.getParentId());
                    second.add(defdocDetailVO.getId());
                    defMap.put(defdocDetailVO.getParentId(), second);
                    continue;
                }
                second = new ArrayList<Long>();
                second.add(defdocDetailVO.getId());
                defMap.put(defdocDetailVO.getParentId(), second);
            }
        }
    }

    private LinkedHashMap<Long, OrgVO> getOrgMap(Boolean continueRoot) {
        CommonResponse orgListRe;
        LinkedHashMap<Long, OrgVO> orgMap = new LinkedHashMap<Long, OrgVO>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(1);
        OrgVO rootOrg = null;
        CommonResponse rootRe = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), typeList, null);
        if (!rootRe.isSuccess() || rootRe.getData() == null || ((List)rootRe.getData()).size() <= 0) {
            throw new BusinessException("\u83b7\u53d6\u96c6\u56e2\u7ec4\u7ec7\u5931\u8d25");
        }
        rootOrg = (OrgVO)((List)rootRe.getData()).get(0);
        if (continueRoot.booleanValue()) {
            orgMap.put(rootOrg.getId(), rootOrg);
        }
        if ((orgListRe = this.orgApi.getDirectChildrenByPid(rootOrg.getId(), null)).isSuccess() && orgListRe.getData() != null && ((List)orgListRe.getData()).size() > 0) {
            List orgList = (List)orgListRe.getData();
            for (OrgVO orgVO : orgList) {
                if (orgVO.getOrgType() != 2) continue;
                orgMap.put(orgVO.getId(), orgVO);
            }
        }
        return orgMap;
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        ArrayList<String> monthList = new ArrayList<String>();
        ArrayList<String> monthSqlList = new ArrayList<String>();
        String beginTime = "";
        String endTime = "";
        for (int i = 6; i > 0; --i) {
            LocalDate month = today.minusMonths(i);
            monthList.add(month.format(DateTimeFormatter.ofPattern("MM")));
            monthSqlList.add(month.format(DateTimeFormatter.ofPattern("yyyy-MM")));
        }
        int dayOfMonth = today.getDayOfMonth();
        if (dayOfMonth >= 10) {
            monthList.remove(0);
            String currentMonthStr = today.format(DateTimeFormatter.ofPattern("MM"));
            monthList.add(currentMonthStr);
            monthSqlList.remove(0);
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            monthSqlList.add(currentMonthStr1);
            LocalDate nextMonth = today.minusMonths(-1L);
            String nextMonthStr = nextMonth.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = nextMonthStr + "-01 00:00:00";
        } else {
            String currentMonthStr1 = today.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            endTime = currentMonthStr1 + "-01 00:00:00";
        }
        beginTime = (String)monthSqlList.get(0) + "-01 00:00:00";
        System.out.println("beginTime\uff1a" + beginTime + ",endTime\uff1a" + endTime);
        for (String lastSixMonth : monthSqlList) {
            System.out.println(lastSixMonth + ",");
        }
    }
}

