package com.ejianc.business.labor.vo;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.util.DigestUtils;


/**
 * 公司花名册班组
 * 
 * @author generator
 * 
 */
public class OrgTeamVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long parentId; // 父ID
    private String parentCode;//上级编码
    private String parentName; //上级名称
    private String code; // 编码
    private String name; // 班组名称
    private String leaderName; // 班组长名称
    private String phone; // 手机号
    private String innerCode; // 内码
    private String innerCodeName; // innerCode
    private Boolean isLeaf; // 是否是叶子节点
    private String sourceType; //类型(1-公司 2-队伍 3-班组)
    private Long sourceId; //来源id
    private Long teamType; //种类
    private String teamTypeName; //种类名称
    private String idCard; //身份证
    private Long corpType; // 参建类型
    private String corpTypeCode; //
    private String corpTypeName; //
    private String pmName; // 项目经理名称
    private Long pmIdCardType; // 项目经理证件类型。参考人员证件类型字典表
    private String pmIdCardTypeCode; //
    private String pmIdCardTypeName; //
    private String pmIdCardNumber; // 项目经理证件号码。AES
    private String pmPhone; // 项目经理电话
    @ReferSerialTransfer(referCode="orgTeamRef")
    public Long getParentId() {
        return parentId;
    }
    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getLeaderName() {
        return leaderName;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean isLleaf) {
        this.isLeaf = isLleaf;
    }

    public Boolean getLeaf() {
        return isLeaf;
    }

    public void setLeaf(Boolean leaf) {
        isLeaf = leaf;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getTeamType() {
        return teamType;
    }
    @ReferDeserialTransfer
    public void setTeamType(Long teamType) {
        this.teamType = teamType;
    }

    public String getTeamTypeName() {
        return teamTypeName;
    }

    public void setTeamTypeName(String teamTypeName) {
        this.teamTypeName = teamTypeName;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getInnerCodeName() {
        return innerCodeName;
    }

    public void setInnerCodeName(String innerCodeName) {
        this.innerCodeName = innerCodeName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCorpType() {
        return corpType;
    }
    @ReferDeserialTransfer
    public void setCorpType(Long corpType) {
        this.corpType = corpType;
    }

    public String getCorpTypeCode() {
        return corpTypeCode;
    }

    public void setCorpTypeCode(String corpTypeCode) {
        this.corpTypeCode = corpTypeCode;
    }

    public String getCorpTypeName() {
        return corpTypeName;
    }

    public void setCorpTypeName(String corpTypeName) {
        this.corpTypeName = corpTypeName;
    }

    public String getPmName() {
        return pmName;
    }

    public void setPmName(String pmName) {
        this.pmName = pmName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPmIdCardType() {
        return pmIdCardType;
    }
    @ReferDeserialTransfer
    public void setPmIdCardType(Long pmIdCardType) {
        this.pmIdCardType = pmIdCardType;
    }

    public String getPmIdCardTypeCode() {
        return pmIdCardTypeCode;
    }

    public void setPmIdCardTypeCode(String pmIdCardTypeCode) {
        this.pmIdCardTypeCode = pmIdCardTypeCode;
    }

    public String getPmIdCardTypeName() {
        return pmIdCardTypeName;
    }

    public void setPmIdCardTypeName(String pmIdCardTypeName) {
        this.pmIdCardTypeName = pmIdCardTypeName;
    }

    public String getPmIdCardNumber() {
        return pmIdCardNumber;
    }

    public void setPmIdCardNumber(String pmIdCardNumber) {
        this.pmIdCardNumber = pmIdCardNumber;
    }

    public String getPmPhone() {
        return pmPhone;
    }

    public void setPmPhone(String pmPhone) {
        this.pmPhone = pmPhone;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String url = "/base/region/v1/add";
        String testJSON = "{\"resData\":{\"regionId\":10174}}";
        JSONObject resJSON = JSONObject.parseObject(testJSON);
        String[] urlSplit = url.split("/");
        JSONObject resData = new JSONObject();
        if(urlSplit[urlSplit.length -1].equals("add")){
            String resDataString = resJSON.getString("resData");
            System.out.println(resDataString);
            if(!resDataString.contains("Id")){
                urlSplit[2] = urlSplit[2]+"Id";
                resData.put(urlSplit[2],resDataString);
            } else {
                resData = resJSON.getJSONObject("resData");
            }

        } else {
            resData = resJSON.getJSONObject("resData");
        }

        System.out.println("转换后resData数据为"+resData);
    }
}
