package com.ejianc.business.other.dangong.vo;

import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 考勤照片上传
 * 
 * @author generator
 *
 *
 * base64	string	是	图片base64编码 （没有文件类型的头）
 * projectId	string	否	项目编号
 * deviceId	string	是	设备编号
 * fileName	string	是	图片名称
 * workerId	string	是	1、系统中的人员编号
 * 2、防疫设备 身份证号或身份证后4位
 * time	string	是	通行时间。毫秒时间戳
 * temp	string	否	体温
 * currentChipCode	string	否	帽子编号
 * direction	string	是	进出方向。默认 in in：进；out：出
 * type	string	否	通行类型。默认 face
 * face： 人脸，
 * idcard： 身份证，
 * health_qr： 健康码，
 * pass_qr： 通行二维码
 * iccard： IC卡
 * pos_type	string	否	gps,baidugis,lbs
 * pos_lat	sting	否	纬度，采用 DD.DDDD 格式
 * pos_lng	sting	否	经度，采用 DD.DDDD 格式
 * 
 */
public class DanGongPersonAttendanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String base64;              // 图片base64编码（没有文件类型的头）
    private String projectId;           // 项目编号（可选）
    private String deviceId;            // 设备编号
    private String fileName;           // 图片名称
    private String workerId;           // 人员编号/身份证号或后4位
    private String time;               // 通行时间（毫秒时间戳）
    private String temp;               // 体温（可选）
    private String currentChipCode;     // 帽子编号（可选）
    private String direction;          // 进出方向（默认"in"）
    private String type;               // 通行类型（默认"face"）
    private String posType;            // 位置类型（gps,baidugis,lbs）（可选）
    private String posLat;             // 纬度（DD.DDDD格式）（可选）
    private String posLng;             // 经度（DD.DDDD格式）（可选）
    private String name;               // 姓名


    // Getters and Setters
    public String getBase64() {
        return base64;
    }

    public void setBase64(String base64) {
        this.base64 = base64;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getWorkerId() {
        return workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getTemp() {
        return temp;
    }

    public void setTemp(String temp) {
        this.temp = temp;
    }

    public String getCurrentChipCode() {
        return currentChipCode;
    }

    public void setCurrentChipCode(String currentChipCode) {
        this.currentChipCode = currentChipCode;
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPosType() {
        return posType;
    }

    public void setPosType(String posType) {
        this.posType = posType;
    }

    public String getPosLat() {
        return posLat;
    }

    public void setPosLat(String posLat) {
        this.posLat = posLat;
    }

    public String getPosLng() {
        return posLng;
    }

    public void setPosLng(String posLng) {
        this.posLng = posLng;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
