package com.ejianc.business.other.dangong.vo;

import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 人员
 * 
 * @author generator
 *
 *
 * data	array	是	工人数据
 * data.name	string	是	工人姓名
 * data.workerId	string	是	工人编号
 * data.photo	string	是	工人照片
 * data.update	string	是	最后更新时间，
 * 该时间为人员信息变更时间，当设备内存储的时间与这个值不一致时，就会自动更新设备内的人员信息。
 * data.projectId	string	是	项目id
 * data.iccard	string	否	ic卡号
 * data.idCardNumber	string	否	身份证号，未加密明文传输
 * data.idCardNumberDes	string	否	身份证号，采用des-ecb加密，no_padding,使用0填充，密钥请和设备商联系
 * data.del	string	否	配合增量数据
 * 0 修改过的数据
 * 1 删除的数据
 * data.plan	object	否	人员通行计划表，不设置表示不限制通行
 * 
 */
public class DanGongPersonVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 工人姓名
     */
    private String name;

    /**
     * 工人编号
     */
    private String workerId;

    /**
     * 工人照片
     */
    private String photo;

    /**
     * 最后更新时间
     */
    private String update;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * ic卡号
     */
    private String iccard;

    /**
     * 身份证号(明文)
     */
    private String idCardNumber;

    /**
     * 身份证号(DES加密)
     */
    private String idCardNumberDes;

    /**
     * 删除标记
     * 0 - 修改过的数据
     * 1 - 删除的数据
     */
    private String del;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWorkerId() {
        return workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public String getUpdate() {
        return update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getIccard() {
        return iccard;
    }

    public void setIccard(String iccard) {
        this.iccard = iccard;
    }

    public String getIdCardNumber() {
        return idCardNumber;
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber;
    }

    public String getIdCardNumberDes() {
        return idCardNumberDes;
    }

    public void setIdCardNumberDes(String idCardNumberDes) {
        this.idCardNumberDes = idCardNumberDes;
    }

    public String getDel() {
        return del;
    }

    public void setDel(String del) {
        this.del = del;
    }

}
