package com.ejianc.business.labor.api;

import com.ejianc.business.labor.hystrix.ProjectTeamHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@FeignClient(name= "ejc-labor-web", url="${common.env.feign-client-url}", path="ejc-labor-web", fallback = ProjectTeamHystrix.class)
public interface IProjectTeamApi {
    /**
     * 根据手机号查询班组长id
     * @param phone
     * @return
     */
    @GetMapping({"/api/projectTeam/queryTeamWorkerIdByPhone"})
    CommonResponse<List<Long>> queryTeamWorkerIdByPhone(@RequestParam("phone") String phone,@RequestParam("projectId") Long projectId);

    /**
     * 修改工资条的申请金额
     * @param map
     * @return
     */
    @PostMapping({"/api/projectTeam/updateAlreadyApplyMny"})
    CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map);

    /**
     * 根据手机号和项目id查询人员Id
     * @param phone
     * @return
     */
    @GetMapping({"/api/projectTeam/queryWorkerIdByPhone"})
    CommonResponse<List<Long>> queryWorkerIdByPhone(@RequestParam("phone") String phone);
}
