package com.ejianc.business.labor.enums;

import com.ejianc.framework.core.response.BillStateEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CheckPhotoFlagEnum {
    待校验(0, "待校验"),

    是(1, "是"),

    否(2, "否"),

    异常(3, "异常");

    private  final Integer code;
    private  final String description;
    private  static Map<Integer, CheckPhotoFlagEnum> enumMap = new HashMap<>();

    CheckPhotoFlagEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    public Integer getCode() {
        return code;
    }
    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(CheckPhotoFlagEnum.class).stream().collect(Collectors.toMap(CheckPhotoFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static CheckPhotoFlagEnum getEnumByStateCode(Integer code) {
        return enumMap.get(code);
    }
}
