/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.SalarySlipVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salarySlip"})
public class SalarySlipController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SALARYSLIP_CODE";
    @Autowired
    private ISalarySlipService service;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalarySlipVO> saveOrUpdate(@RequestBody SalarySlipVO saveOrUpdateVO) {
        SalarySlipEntity entity = (SalarySlipEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalarySlipEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalarySlipVO vo = (SalarySlipVO)BeanMapper.map((Object)((Object)entity), SalarySlipVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalarySlipVO> queryDetail(Long id) {
        SalarySlipEntity entity = (SalarySlipEntity)((Object)this.service.selectById(id));
        SalarySlipVO vo = (SalarySlipVO)BeanMapper.map((Object)((Object)entity), SalarySlipVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalarySlipVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalarySlipVO salarySlipVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<SalarySlipVO> list = this.service.querySalarySlipVOPage(wrapper, salaryMonth, (Page<SalarySlipVO>)page);
        if (CollectionUtils.isNotEmpty(list)) {
            for (SalarySlipVO salarySlipVO : list) {
                salarySlipVO.setBaseImgUrl(this.baseImgUrl);
            }
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<SalarySlipVO> list = this.service.querySalarySlipVOPage(wrapper, salaryMonth, null);
        if (CollectionUtils.isNotEmpty(list)) {
            for (SalarySlipVO salarySlipVO : list) {
                if (salarySlipVO.getSex() != null) {
                    if (1 == salarySlipVO.getSex()) {
                        salarySlipVO.setSexName("\u7537");
                    } else if (2 == salarySlipVO.getSex()) {
                        salarySlipVO.setSexName("\u5973");
                    }
                }
                if (1 == salarySlipVO.getSource()) {
                    salarySlipVO.setSourceName("\u82b1\u540d\u518c");
                } else if (2 == salarySlipVO.getSource()) {
                    salarySlipVO.setSourceName("\u81ea\u5236");
                }
                if (1 == salarySlipVO.getAckFlag()) {
                    salarySlipVO.setAckFlagName("\u5df2\u786e\u8ba4");
                    continue;
                }
                if (0 != salarySlipVO.getAckFlag()) continue;
                salarySlipVO.setAckFlagName("\u672a\u786e\u8ba4");
            }
        }
        HashMap<String, List<SalarySlipVO>> beans = new HashMap<String, List<SalarySlipVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SalarySlip-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalarySlipData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> refSalarySlipData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("bankCard");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long contractId = null;
        Long projectId = null;
        String contractFlag = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"contractId")) {
                contractId = Long.parseLong(_con.get((Object)"contractId").toString());
            }
            if (_con.containsKey((Object)"projectId")) {
                projectId = Long.parseLong(_con.get((Object)"projectId").toString());
            }
            if (_con.containsKey((Object)"contractFlag")) {
                contractFlag = _con.get((Object)"contractFlag").toString();
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<SalarySlipVO> list = this.service.querySalarySlipDataPage(contractId, projectId, wrapper, (Page<SalarySlipVO>)page, contractFlag);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/ackSalary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalarySlipVO> ackSalary(@RequestBody SalarySlipVO vo) {
        SalarySlipEntity salarySlipEntity = (SalarySlipEntity)((Object)this.service.selectById(vo.getId()));
        LambdaUpdateWrapper salarySlipAckWrapper = new LambdaUpdateWrapper();
        salarySlipAckWrapper.eq(BaseEntity::getId, (Object)vo.getId());
        salarySlipAckWrapper.set(SalarySlipEntity::getAckFlag, (Object)1);
        salarySlipAckWrapper.set(SalarySlipEntity::getAckTime, (Object)new Date());
        salarySlipAckWrapper.set(SalarySlipEntity::getLogonPeopleId, (Object)salarySlipEntity.getWorkerId());
        salarySlipAckWrapper.set(SalarySlipEntity::getLogonPeople, (Object)salarySlipEntity.getWorkerName());
        salarySlipAckWrapper.set(SalarySlipEntity::getFacePhotoId, (Object)vo.getFacePhotoId());
        salarySlipAckWrapper.set(SalarySlipEntity::getFacePhoto, (Object)vo.getFacePhoto());
        salarySlipAckWrapper.set(SalarySlipEntity::getSignPhotoId, (Object)vo.getSignPhotoId());
        salarySlipAckWrapper.set(SalarySlipEntity::getSignPhoto, (Object)vo.getSignPhoto());
        this.service.update((Wrapper)salarySlipAckWrapper);
        SalarySlipEntity entity = (SalarySlipEntity)((Object)this.service.selectById(vo.getId()));
        SalarySlipVO salarySlipVO = (SalarySlipVO)BeanMapper.map((Object)((Object)entity), SalarySlipVO.class);
        return CommonResponse.success((String)"\u5de5\u8d44\u6761\u786e\u8ba4\u6210\u529f\uff01", (Object)salarySlipVO);
    }

    @RequestMapping(value={"/querySalarySlipList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> querySalarySlipList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<SalarySlipVO> list = this.service.querySalarySlipVOPage(wrapper, salaryMonth, (Page<SalarySlipVO>)page);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryProjectSalarySlipList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> queryProjectSalarySlipList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        Long projectId = null;
        if (!params.containsKey("projectId")) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        projectId = Long.parseLong((String)((Parameter)params.get("projectId")).getValue());
        param.getParams().remove("projectId");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.isNotNull((Object)"worker_id");
        List<SalarySlipVO> list = this.service.querySalarySlipVOPage(wrapper, salaryMonth, (Page<SalarySlipVO>)page);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryTeamSalarySlipList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> queryTeamSalarySlipList(@RequestBody QueryParam param) {
        List<WorkRecordVO> workRecordVOs;
        List<Long> teamIds;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        String phone = null;
        Long userId = this.sessionManager.getUserContext().getUserId();
        CommonResponse commonResponse = this.employeeApi.getById(userId);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            EmployeeVO employeeVO = (EmployeeVO)commonResponse.getData();
            phone = employeeVO.getMobilePhone();
        }
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        Long projectId = null;
        if (params.containsKey("projectId")) {
            projectId = Long.parseLong((String)((Parameter)params.get("projectId")).getValue());
            param.getParams().remove("projectId");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"phone", (Object)phone);
        objectQueryWrapper.eq((Object)"project_id", (Object)projectId);
        List projectTeamList = this.projectTeamService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)projectTeamList) && CollectionUtils.isNotEmpty(teamIds = projectTeamList.stream().filter(s -> s.getId() != null).map(BaseEntity::getId).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(workRecordVOs = this.service.queryWorkByTeamId(projectId, teamIds))) {
            List workIds = workRecordVOs.stream().filter(s -> s.getWorkerId() != null).map(WorkRecordVO::getWorkerId).collect(Collectors.toList());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            wrapper.in((Object)"worker_id", workIds);
            List<SalarySlipVO> list = this.service.queryTeamSalarySlipList(wrapper, salaryMonth, (Page<SalarySlipVO>)page, null);
            page.setTotal(page.getTotal());
            page.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryWorkerSalarySlipList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> queryWorkerSalarySlipList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        String phone = null;
        if (params.containsKey("phone")) {
            phone = (String)((Parameter)params.get("phone")).getValue();
            param.getParams().remove("phone");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"phone", (Object)phone);
        objectQueryWrapper.eq((Object)"last_flag", (Object)1);
        List workRecordList = this.workRecordService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)workRecordList)) {
            List workerIds = workRecordList.stream().filter(s -> s.getWorkerId() != null).map(WorkRecordEntity::getWorkerId).collect(Collectors.toList());
            param.getParams().put("worker_id", new Parameter("in", workerIds));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<SalarySlipVO> list = this.service.querySalarySlipVOPage(wrapper, salaryMonth, (Page<SalarySlipVO>)page);
            page.setTotal(page.getTotal());
            page.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"getContractSumSalary"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalarySlipVO> getContractSumSalary(@RequestParam(value="contractId", required=true) Long contractId) {
        SalarySlipVO vo = this.service.getContractSumSalary(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

