/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.base.bean.BaseTeamEntity;
import com.ejianc.business.base.service.IBaseTeamService;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.mapper.OrgTeamMapper;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgTeamService")
public class OrgTeamServiceImpl
extends BaseServiceImpl<OrgTeamMapper, OrgTeamEntity>
implements IOrgTeamService {
    @Autowired
    private OrgTeamMapper orgTeamMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LABOR_ORG_TEAM";
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IBaseTeamService baseTeamService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<OrgTeamVO> queryListTree(Map<String, Object> params) {
        List<OrgTeamVO> orgTeamList = this.orgTeamMapper.queryListTree(params);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<OrgTeamVO> orgTeamList = this.orgTeamMapper.queryListByPid(tenantId, id);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryCategoryListByIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<OrgTeamVO> orgTeamList = this.orgTeamMapper.queryListByIds(params);
        return orgTeamList;
    }

    @Override
    public OrgTeamVO insertOrUpdate(OrgTeamVO saveOrUpdateVO) {
        String oldName;
        LambdaUpdateWrapper parentWrapper;
        OrgTeamEntity entity = (OrgTeamEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrgTeamEntity.class));
        Long parentId = entity.getParentId();
        String name = entity.getName();
        Long id = entity.getId();
        OrgTeamEntity _orgTeamEntity = null;
        if (id == null || id == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            if (entity.getSourceId() == null) {
                BillCodeParam baseTeamBillCodeParam = BillCodeParam.build((String)"Invoice_Open_Apply_Code", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse baseTeamBillCode = this.billCodeApi.generateBillCode(baseTeamBillCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                BaseTeamEntity baseTeamEntity = new BaseTeamEntity();
                baseTeamEntity.setBillCode((String)baseTeamBillCode.getData());
                baseTeamEntity.setTeamName(entity.getName());
                baseTeamEntity.setSourceType(entity.getSourceType());
                baseTeamEntity.setResponsiblePersonIdCardType(entity.getPmIdCardType());
                baseTeamEntity.setResponsiblePersonIdCardTypeCode(entity.getPmIdCardTypeCode());
                baseTeamEntity.setResponsiblePersonIdCardTypeCodeName(entity.getPmIdCardTypeName());
                baseTeamEntity.setResponsiblePersonIdNumber(entity.getPmIdCardNumber());
                baseTeamEntity.setResponsiblePersonName(entity.getPmName());
                baseTeamEntity.setResponsiblePersonPhone(entity.getPmPhone());
                UserContext userContextCache = this.sessionManager.getUserContext();
                baseTeamEntity.setOrgId(userContextCache.getOrgId());
                baseTeamEntity.setOrgName(userContextCache.getOrgName());
                baseTeamEntity.setId(IdWorker.getId());
                this.baseTeamService.saveOrUpdate((Object)baseTeamEntity);
                entity.setSourceId(baseTeamEntity.getId());
            }
        } else {
            _orgTeamEntity = (OrgTeamEntity)((Object)this.selectById(entity.getId()));
            Long oldParentId = _orgTeamEntity.getParentId();
            if (oldParentId != null && !oldParentId.equals(parentId)) {
                LambdaUpdateWrapper countParentWrapper = new LambdaUpdateWrapper();
                countParentWrapper.eq(OrgTeamEntity::getParentId, (Object)oldParentId);
                countParentWrapper.ne(BaseEntity::getId, (Object)entity.getId());
                int countOldParentNum = this.count((Wrapper)countParentWrapper);
                parentWrapper = new LambdaUpdateWrapper();
                parentWrapper.set(OrgTeamEntity::getIsLeaf, (Object)(countOldParentNum <= 0 ? 1 : 0));
                parentWrapper.eq(BaseEntity::getId, (Object)oldParentId);
                this.update((Wrapper)parentWrapper);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper curWrapper = new LambdaUpdateWrapper();
        curWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        String innerCode = entity.getId().toString();
        String innerCodeName = entity.getName();
        if (parentId != null) {
            parentWrapper = new LambdaUpdateWrapper();
            parentWrapper.set(OrgTeamEntity::getIsLeaf, (Object)false);
            parentWrapper.eq(BaseEntity::getId, (Object)parentId);
            this.update((Wrapper)parentWrapper);
            OrgTeamEntity parentEntity = (OrgTeamEntity)((Object)this.selectById(entity.getParentId()));
            innerCode = parentEntity.getInnerCode() + "|" + entity.getId();
            innerCodeName = parentEntity.getInnerCodeName() + "|" + entity.getName();
            curWrapper.set(OrgTeamEntity::getParentCode, (Object)parentEntity.getCode());
        }
        curWrapper.set(OrgTeamEntity::getInnerCode, (Object)innerCode);
        curWrapper.set(OrgTeamEntity::getInnerCodeName, (Object)innerCodeName);
        LambdaQueryWrapper childQueryWrapper = new LambdaQueryWrapper();
        childQueryWrapper.ne(BaseEntity::getId, (Object)entity.getId());
        childQueryWrapper.likeRight(OrgTeamEntity::getInnerCode, (Object)entity.getInnerCode());
        List childList = this.list((Wrapper)childQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)childList)) {
            for (OrgTeamEntity childOrgTeamEntity : childList) {
                LambdaUpdateWrapper childUpdWrapper = new LambdaUpdateWrapper();
                childUpdWrapper.set(OrgTeamEntity::getInnerCode, (Object)(innerCode + "|" + childOrgTeamEntity.getId()));
                childUpdWrapper.eq(BaseEntity::getId, (Object)childOrgTeamEntity.getId());
                this.update((Wrapper)childUpdWrapper);
            }
            curWrapper.set(OrgTeamEntity::getIsLeaf, (Object)Boolean.FALSE);
        } else {
            curWrapper.set(OrgTeamEntity::getIsLeaf, (Object)Boolean.TRUE);
        }
        boolean update = this.update((Wrapper)curWrapper);
        if (id != null && _orgTeamEntity != null && update && StringUtils.isNotEmpty((CharSequence)(oldName = _orgTeamEntity.getName())) && !oldName.equals(name)) {
            this.workerService.updateWorkerTeamNameByTeamIdOrWorkerId(id, null);
        }
        OrgTeamVO vo = (OrgTeamVO)BeanMapper.map((Object)((Object)entity), OrgTeamVO.class);
        return vo;
    }
}

