package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 劳务进场单
 * 
 * @author generator
 * 
 */
public interface IWorkerEnterService extends IBaseService<WorkerEnterEntity> {

    WorkerEnterVO saveOrUpdate(WorkerEnterVO saveOrUpdateVO);

    /**
     *  保存前校验
     *  id
     *  idCard
     *  phone
     *  projectId
     * @param vo
     * @return
     */
    CommonResponse<JSONObject> saveCheck(WorkerEnterVO vo);

    /**
     *  审批通过 回写 或插入数据
     * @param entity
     */
     void bpmWriteBackAndInsert(WorkerEnterEntity entity);

    Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId);

    /**
     * 返回ui大屏 劳务用工统计
     * @param filterOrgId
     * @return
     */
    CommonResponse<JSONObject> topWorkRecord (FilterOrgIdVo filterOrgId);
}
