package com.ejianc.business.other.dangong.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.dangong.vo.DanGongPublicResultVO;
import com.ejianc.business.other.dangong.vo.DanGongResultUtils;
import com.ejianc.business.other.henger.enums.ServiceTypeEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.xml.transform.Result;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: jiang
 * @Date: 2025/8/7 17:57
 **/
@Controller
@RequestMapping("danGongPerson")
public class DanGongPersonController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DanGongPersonApiService danGongPersonApiService;


    /**
     * init初始化配置请求
     * @return
     */
    @RequestMapping(value = "/init", method = RequestMethod.GET)
    @ResponseBody
    public DanGongPublicResultVO init(@RequestParam("deviceId") String deviceId,
                                      @RequestParam("productId") String productId,
                                      @RequestParam("mac") String mac,
                                      @RequestParam("porttype") String porttype) {
        logger.info("弹弓初始化配置");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dgBaseInfo","");
        jsonObject.put("setting","");
        logger.info("弹弓初始化配置返回结果{}",JSONObject.toJSONString(DanGongResultUtils.success("init",jsonObject)));
        return DanGongResultUtils.success("init",jsonObject);
    }


    /**
     * 下载白名单
     * @return
     */
    @RequestMapping(value = "/workers", method = RequestMethod.GET)
    @ResponseBody
    public String workers(@RequestParam("deviceId") String deviceId,
                                         @RequestParam("productId") String productId,
                                         @RequestParam("update") String update) {
        logger.info("弹弓获取人员信息开始");
        List<DanGongPersonVO> workerList = danGongPersonApiService.getWorkerList(deviceId, productId, update);
        logger.info("弹弓获取人员信息结果{}",JSONObject.toJSONString(DanGongResultUtils.success("workers",workerList)));
        DanGongPublicResultVO<List<DanGongPersonVO>> resultVO = DanGongResultUtils.success("workers", workerList);
        return JSONObject.toJSONString(DanGongResultUtils.success("workers",workerList));
    }
//    /**
//     * 考勤照片上传
//     * @return
//     */
//    @RequestMapping(value = "/photo", method = RequestMethod.POST)
//    @ResponseBody
//    public DanGongPublicResultVO photo(@RequestParam("ts") String ts,
//                                       @RequestParam("deviceId") String ts) {
//        logger.info("弹弓获取考勤数据开始");
//        List<DanGongPersonVO> workerList = danGongPersonApiService.getWorkerList(deviceId, productId, update);
//        logger.info("获取人员信息结果{}",JSONObject.toJSONString(DanGongResultUtils.success("workers",workerList)));
//        return DanGongResultUtils.success("workers",workerList);
//    }

}
