package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.other.xiaoshi.service.XiaoShiGroupApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("XiaoShiGroupApiService")
public class XiaoShiGroupApiServiceImpl implements XiaoShiGroupApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private XiaoShiPublicApiService publicApiService;



    @Override
    public String add(PorjectEntity entity) {

        /**
         * 发送请求
         */
        String apiUrl = "/base/group/v1/add";

        JSONObject queryParam = new JSONObject();
        queryParam.put("groupName",entity.getName());
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        return resData.getString("groupId");
    }
}
