package com.ejianc.business.other.dangong.service.api;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.dangong.vo.DanGongPublicResultVO;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;

import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.business.other.yufan.service.YuFanPersonApiService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service("DanGongPersonApiService")
public class DanGongPersonApiServiceImpl implements DanGongPersonApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IAttachmentApi attachmentApi;


    @Override
    public List<DanGongPersonVO> getWorkerList(String deviceId, String productId, String update) {
        HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(deviceId);
        Long projectId = hengErEquipVO.getProjectId();


        List<DanGongPersonVO> danGongPersonVOS = new ArrayList<>();
        if("0".equals(update)){
            //全量同步
            logger.info("全量同步开始1-------------");
            List<WorkRecordEntity> list = workRecordService.list(Wrappers.<WorkRecordEntity>lambdaQuery()
                    .eq(WorkRecordEntity::getProjectId, projectId)
            );
            if(ListUtil.isNotEmpty(list)) {

                for (WorkRecordEntity workRecordEntity : list) {
                    Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> fileData = listCommonResponse.getData();
                        if (ListUtil.isEmpty(fileData)) {
                            logger.info("无图片信息！");
                        }
                        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                                .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    } else {
                        throw new BusinessException("访问文件服务异常!");
                    }
                    DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
                    danGongPersonVO.setName(workRecordEntity.getName());
                    danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
                    String url = "http://csqlh.zzyjjt.com/" + fileIdRef.get(workRecordEntity.getId()).getFilePath();
                    danGongPersonVO.setPhoto(url);
                    if (workRecordEntity.getEnterExitState().equals(0)) {
                        danGongPersonVO.setDel("1");
                    } else {
                        danGongPersonVO.setDel("0");
                    }
                    danGongPersonVO.setIdCardNumber(workRecordEntity.getIdCard());

                    Date updateTime = new Date();
                    if (workRecordEntity.getUpdateTime() != null) {
                        updateTime = workRecordEntity.getUpdateTime();
                    } else if (workRecordEntity.getCreateTime() != null) {
                        updateTime = workRecordEntity.getCreateTime();
                    }
                    long time = updateTime.getTime() / 1000;
                    danGongPersonVO.setUpdate(String.valueOf(time));
                    danGongPersonVOS.add(danGongPersonVO);
                }
            }
        } else {
            logger.info("增量同步开始2-------------");
            //增量同步
            DateTime date = DateUtil.date(Long.parseLong(update));
            List<WorkRecordEntity> list = workRecordService.list(Wrappers.<WorkRecordEntity>lambdaQuery()
                    .eq(WorkRecordEntity::getProjectId, projectId)
                    .ge(WorkRecordEntity::getUpdateTime, date)
            );
            if(ListUtil.isNotEmpty(list)){

                for (WorkRecordEntity workRecordEntity : list) {
                    Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(workRecordEntity.getId(), null, null, null);
                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> fileData = listCommonResponse.getData();
                        if (ListUtil.isEmpty(fileData)) {
                            logger.info("无图片信息！");
                        }
                        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                                .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    } else {
                        throw new BusinessException("访问文件服务异常!");
                    }
                    DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
                    danGongPersonVO.setName(workRecordEntity.getName());
                    danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
                    String url = "http://csqlh.zzyjjt.com/" + fileIdRef.get(workRecordEntity.getId()).getFilePath();
                    danGongPersonVO.setPhoto(url);
                    if(workRecordEntity.getEnterExitState().equals(0)){
                        danGongPersonVO.setDel("1");
                    } else {
                        danGongPersonVO.setDel("0");
                    }
                    danGongPersonVO.setIdCardNumber(workRecordEntity.getIdCard());

                    Date updateTime = new Date();
                    if(workRecordEntity.getUpdateTime() != null){
                        updateTime = workRecordEntity.getUpdateTime();
                    } else if(workRecordEntity.getCreateTime() != null){
                        updateTime = workRecordEntity.getCreateTime();
                    }
                    long time = updateTime.getTime()/1000;
                    danGongPersonVO.setUpdate(String.valueOf(time));
                    danGongPersonVOS.add(danGongPersonVO);
                }
            }

        }
        return danGongPersonVOS;
    }
}
