package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.TypeVO;
import com.ejianc.business.labor.bean.*;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.mapper.WorkRecordMapper;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.business.labor.vo.WorkRecordBankInfoVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.bean.HengErTaskEntity;
import com.ejianc.business.other.henger.enums.ConTypeEnum;
import com.ejianc.business.other.henger.enums.EquipStatusEnum;
import com.ejianc.business.other.henger.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.business.other.henger.service.api.HengErPersonApiServiceImpl;
import com.ejianc.business.other.henger.vo.HengErTaskVO;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPersonApiService;
import com.ejianc.business.other.yufan.service.YuFanPersonApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 用工记录
 *
 * @author generator
 *
 */
@Service("workRecordService")
public class WorkRecordServiceImpl extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity> implements IWorkRecordService{
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RECORD_BILL_TYPE = "BT202211000002";//用工记录 billType
    private static final String ENTER_BILL_TYPE = "BT202211000003";//劳务进场 billType
    private static final String WORKER_BILL_TYPE = "BT202211000007";//劳务 billType
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";// 身份证信息正面 sourceType
    private static final String IDBACK_TYPE = "idCardBack";// 身份证信息反面sourceType
    private static final String FACE_TYPE = "face";// 人脸 sourceType ORDER_TYPE
    private static final String ORDER_TYPE = "desc";//ORDER_TYPE

    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";// 用工记录 附件管理 sourceType
    private static final String ENTER_FILE_SOURCE_TYPE = "worker001";// 劳务进场 附件管理 sourceType
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";// 劳务 附件管理 sourceType
    @Value("${fileUrl}")
    private String fileUrl;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    IAttendanceService attendanceService;
    @Resource
    private IFaceService faceService;

    @Autowired
    private HengErPersonApiServiceImpl hengErPersonApiService;

    @Autowired
    private IHengErEquipService equipService;

    @Autowired
    private IHengErTaskService hengErTaskService;

    @Autowired
    private IPorjectService porjectService;

    @Autowired
    private XiaoShiPersonApiService xiaoShiPersonApiService;

    @Autowired
    private YuFanPersonApiService fanPersonApiService;

    @Autowired
    private IWorkerBankInfoService workerBankInfoService;

    /**
     * 公司推送 设置:
     *      teamId teamName orgTeamId orgTeamName
     *      workType workTypeName orgWorkType  orgWorkTypeName
     *
     *
     * 项目推送 设置:
     *      teamId teamName projectTeamId projectTeamName
     *      workType workTypeName projectWorkType projectWorkTypeName
     *
     *
     * 设置来源: sourceFlag 来源（1自制-劳务进场单、2公司花名册、3邀请）
     * @param voList
     * @return
     */
    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList){
        List<WorkRecordVO> returnList = new ArrayList<>();
        for (WorkRecordVO vo:voList){
            //根据用户 id 查询
            QueryWrapper<WorkRecordEntity> query = new QueryWrapper<>();
            query.eq("project_id", vo.getProjectId());
            query.eq("last_flag", LastFlagEnum.是.getStatus());
            query.eq("worker_id", vo.getWorkerId());
            if (vo.getId()!=null){
                query.ne("id", vo.getId());
            }
            WorkRecordEntity one = super.getOne(query);
            //存在修改旧的
            if (one!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(WorkRecordEntity::getLastFlag,LastFlagEnum.否.getStatus());
                wrapper.eq(WorkRecordEntity::getId,one.getId());
                super.update(wrapper);
            }
            WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
            if (vo.getWorkType()!=null&&vo.getWorkType().isEmpty()){
                entity.setWorkType(null);
                entity.setWorkTypeName(null);
            }
            entity.setLastFlag(LastFlagEnum.是.getStatus());
//            entity.setEnterDate(new Date());





            super.saveOrUpdate(entity);
            WorkRecordVO recordVO = BeanMapper.map(entity, WorkRecordVO.class);
            returnList.add(recordVO);
            //引入认证信息 这里劳务进场推送的时候 会先推送到公司花名册  也就是说 无脑公司就可已
            orgToProjectCertified(entity);

            /**
             * 根据项目硬件对接平台，推送数据
             */
            PorjectEntity porjectEntity = porjectService.selectById(entity.getProjectId());
            if(StringUtils.isNotEmpty(porjectEntity.getConType())){
                if(porjectEntity.getConType().equals(ConTypeEnum.小视.getStatus())){
                    /**
                     * 同步到小视第三方平台,并返回personId
                     */
                    String personId = xiaoShiPersonApiService.add(vo);
                    entity.setPersonId(personId);
                } else if(porjectEntity.getConType().equals(ConTypeEnum.恒尔.getStatus())){
                    /**
                     * 恒尔同步
                     */
                    //获取所有同步过的设备
                    List<HengErEquipEntity> hengErEquipEntities = equipService.list(Wrappers.<HengErEquipEntity>lambdaQuery()
                            .eq(HengErEquipEntity::getProjectId, vo.getProjectId())
                            .ne(HengErEquipEntity::getEquipStatus, EquipStatusEnum.未同步)
                            .in(HengErEquipEntity::getBillState, Arrays.asList(1,3)));
                    if(ListUtil.isNotEmpty(hengErEquipEntities)){
                        for (HengErEquipEntity hengErEquipEntity : hengErEquipEntities) {
                            //获取指令
                            JSONObject serviceRequest = hengErPersonApiService.getAddCom(vo, hengErEquipEntity.getEquipSn());
                            //构建任务队列
                            hengErTaskService.addTaskByType(
                                    hengErEquipEntity.getEquipSn(),
                                    vo.getId(),
                                    ServiceTypeEnum.单个名单添加.getStatus(),
                                    serviceRequest.toJSONString());

                        }
                    }
                } else if(porjectEntity.getConType().equals(ConTypeEnum.宇泛.getStatus())){
                    String personId = fanPersonApiService.addOrUpdate(vo);



                }
            }

        }
        return returnList;
    }

    void orgToProjectCertified(WorkRecordEntity entity){
        List<String> typeList = new ArrayList();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s :typeList){
            //1.公司花名册 是否存在
            CommonResponse<List<AttachmentVO>> idCardResponse = attachmentApi.queryListBySourceId(
                    entity.getWorkerId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            //2.存在就修改项目花名册用工记录
            if (CollectionUtils.isNotEmpty(idCardResponse.getData())){
                //3.查询项目花名册用工记录 是否存在
                CommonResponse<List<AttachmentVO>> orgIdCardResponse = attachmentApi.queryListBySourceId(
                        entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);

                if (!orgIdCardResponse.isSuccess()){
                    throw new BusinessException("网络异常 查询文件中心异常");
                }
                if (CollectionUtils.isNotEmpty(orgIdCardResponse.getData())){
                    //4.项目花名册用工记录 存在就删除
                    CommonResponse<String> deleteFileByParam = attachmentApi.deleteFileByParam(
                            entity.getId(), RECORD_BILL_TYPE, s);
                    if (!deleteFileByParam.isSuccess()){
                        throw new BusinessException("网络异常 文件中心删除失败");
                    }
                }
                CommonResponse<List<AttachmentVO>> orgIdCardResponseTow = attachmentApi.queryListBySourceId(
                        entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);

                logger.info("****************:{}", JSON.toJSONString(orgIdCardResponseTow));
                //5.然后写入公司花名册
                CommonResponse<String> commonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(entity.getWorkerId()), WORKER_BILL_TYPE,s ,
                        Long.toString(entity.getId()), RECORD_BILL_TYPE,s );
                if (!commonResponse.isSuccess()){
                    throw new BusinessException("网络异常 文件中心复制失败");
                }
            }

        }


    }
    /**
     *  如修改了基本信息（除班组外）
     *  修改后会自动同步公司花名册
     * @param vo
     * @return
     */
    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        LambdaQueryWrapper<WorkerEntity> idCardQueryWrapper = new LambdaQueryWrapper<>();
        idCardQueryWrapper.eq(WorkerEntity::getIdCard, vo.getIdCard());
        idCardQueryWrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
        idCardQueryWrapper.ne(vo.getWorkerId() != null, WorkerEntity::getId, vo.getWorkerId());
        List<WorkerEntity> idCardList = workerService.list(idCardQueryWrapper);

        LambdaQueryWrapper<WorkerEntity> phoneQueryWrapper = new LambdaQueryWrapper<>();
        phoneQueryWrapper.eq(WorkerEntity::getPhone, vo.getPhone());
        phoneQueryWrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
        phoneQueryWrapper.ne(vo.getWorkerId() != null, WorkerEntity::getId, vo.getWorkerId());
        List<WorkerEntity> phoneList = workerService.list(phoneQueryWrapper);
        if (CollectionUtils.isNotEmpty(idCardList)) {
            throw new BusinessException("保存或修改单据失败，公司花名册身份证已存在");
        } else if (CollectionUtils.isNotEmpty(phoneList)) {
            throw new BusinessException("保存或修改单据失败，公司花名册手机号已存在");
        }
        WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
        super.saveOrUpdate(entity,false);
        WorkerEntity workerEntity= workerService.selectById(entity.getWorkerId());
        // 回写数据到 公司花名册 班组外
        if (workerEntity!=null){
            // 最后更新的项目id
            workerEntity.setLastProjectId(entity.getProjectId());
            if (entity.getName()!=null){//姓名
                workerEntity.setName(entity.getName());
            }
            if (entity.getPhone()!=null){//手机号
                workerEntity.setPhone(entity.getPhone());
            }
            if (entity.getSex()!=null){//性别
                workerEntity.setSex(entity.getSex());
            }
            if (entity.getBirthDate()!=null){//出生年月
                workerEntity.setBirthDate(entity.getBirthDate());
            }
            if (entity.getNation()!=null){// 民族
                workerEntity.setNation(entity.getNation());
            }
            if (entity.getWorkType()!=null&&!entity.getWorkType().isEmpty()){// 工种
                workerEntity.setWorkType(entity.getWorkType());
            }
            if (entity.getWorkTypeName()!=null&&!entity.getWorkType().isEmpty()){// 工种名称
                workerEntity.setWorkTypeName(entity.getWorkTypeName());
            }
            if (entity.getBankName()!=null){// 开户行
                workerEntity.setBankName(entity.getBankName());
            }
            if (entity.getBankAccount()!=null){// 银行账号
                workerEntity.setBankAccount(entity.getBankAccount());
            }
            if (entity.getWagesType()!=null){// 工资类型
                workerEntity.setWagesType(entity.getWagesType());
            }
            if (entity.getWagesTypeName()!=null){// 工资类型名称
                workerEntity.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getWage()!=null){// 工价
                workerEntity.setWage(entity.getWage());
            }
            if (entity.getProvince()!=null){// 省
                workerEntity.setProvince(entity.getProvince());
            }
            if (entity.getCity()!=null){// 市
                workerEntity.setCity(entity.getCity());
            }
            if (entity.getArea()!=null){// 省市
                workerEntity.setArea(entity.getArea());
            }
            if (entity.getAddress()!=null){// 详细地址
                workerEntity.setAddress(entity.getAddress());
            }
            if (entity.getWagesTypeName()!=null){// 工资类型名称
                workerEntity.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getMemo()!=null){// 备注
                workerEntity.setMemo(entity.getMemo());
            }

            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
//            if(null!=entity.getFacePhotoFlag()){
//                workerEntity.setMemo(entity.getMemo());
//
//            }

            workerService.saveOrUpdate(workerEntity);
            updateAttachmentCheck(entity);
            //查询项目花名册是否存在附件 项目花名册 往公司花名册 上加
            CommonResponse<List<AttachmentVO>> recordFileResponse = attachmentApi.queryListBySourceId(
                    entity.getId(), RECORD_BILL_TYPE, RECORD_FILE_SOURCE_TYPE, ORDER_TYPE);
            if (!recordFileResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            if (CollectionUtils.isNotEmpty(recordFileResponse.getData())){
                //写入公司花名册附件
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(entity.getId()),RECORD_BILL_TYPE,RECORD_FILE_SOURCE_TYPE,
                        Long.toString(entity.getWorkerId()),WORKER_BILL_TYPE,WORKER_FILE_SOURCE_TYPE);
            }
        }
        if (entity.getSourceFlag()==1){
            // 分包合同、供应商：修改时需要回写对应的进场记录；
            WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(entity.getSourceId());
            if (workerEnterEntity!=null){
                if (entity.getSubContractId()!=null){
                    // 分包合同、供应商
                    workerEnterEntity.setSubContractId(entity.getSubContractId());
                    workerEnterEntity.setSubContractName(entity.getSubContractName());
                    workerEnterEntity.setSupplierId(entity.getSupplierId());
                    workerEnterEntity.setSubContractName(entity.getSupplierName());
                }
                workerEnterService.saveOrUpdate(workerEnterEntity);
            }
        }
        WorkRecordVO returnVo = BeanMapper.map(entity, WorkRecordVO.class);
        returnVo.setBillState(0);


        /**
         * 处理银行账户信息
         */
        List<WorkRecordBankInfoVO> bankInfoList = vo.getWorkRecordBankInfoList();

        List<WorkerBankInfoEntity> bankInfoEntities = workerBankInfoService.list(Wrappers.<WorkerBankInfoEntity>lambdaQuery()
                .eq(WorkerBankInfoEntity::getZhuId, vo.getWorkerId())
        );

        List<WorkerBankInfoEntity> newBankInfoList = new ArrayList<>();
        for (WorkRecordBankInfoVO bankInfoVO : bankInfoList) {
            for (WorkerBankInfoEntity bankInfoEntity : bankInfoEntities) {
                bankInfoEntity.setDefaultFlag(0);
                if(bankInfoVO.getBankCode().equals(bankInfoEntity.getBankCode())){
                    if(bankInfoVO.getDefaultFlag() == 1 ){
                        bankInfoEntity.setDefaultFlag(1);
                    }
                    bankInfoEntity.setBankAccount(bankInfoVO.getBankAccount());
                    bankInfoEntity.setBankAddress(bankInfoVO.getBankAddress());
                    bankInfoEntity.setBankCode(bankInfoVO.getBankCode());
                }
            }
            if(bankInfoVO.getSourceId() == null){
                WorkerBankInfoEntity newBankInfo = BeanMapper.map(bankInfoVO, WorkerBankInfoEntity.class);
                newBankInfo.setZhuId(vo.getWorkerId());
                newBankInfoList.add(newBankInfo);
            }
        }
        if(ListUtil.isNotEmpty(newBankInfoList)){
            bankInfoEntities.addAll(newBankInfoList);
            workerBankInfoService.saveOrUpdateBatch(bankInfoEntities);
        }
        return returnVo;
    }

    @Override
    public WorkRecordVO updateBatWorker(WorkRecordVO updateVO) {
        List<Long> ids = updateVO.getIds();//用户ids
        String teamId = updateVO.getTeamId();//所选班组
        String teamName = updateVO.getTeamName();//班组名称
        String workType = updateVO.getWorkType();//所选工种
        String workTypeName = updateVO.getWorkTypeName();//工种名称
        Long supplierId = updateVO.getSupplierId();
        String supplierName = updateVO.getSupplierName();
        Long subContractId = updateVO.getSubContractId();
        String subContractName = updateVO.getSubContractName();

        if(CollectionUtils.isNotEmpty(ids)){
            //回写数据
            QueryWrapper<WorkRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("id",ids);
            List<WorkRecordEntity> list = super.list(queryWrapper);
            List<Long> workerEntities = new ArrayList<>();
            List<Long> enterEntities = new ArrayList<>();
            for (WorkRecordEntity record:list){
                if (record.getSourceFlag()==1){
                    enterEntities.add(record.getSourceId());
                }
                workerEntities.add(record.getWorkerId());
            }


            if(teamName!=null || workType!=null||subContractId!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                LambdaUpdateWrapper<WorkerEntity> workerEntityWrapper = new LambdaUpdateWrapper<>();
                LambdaUpdateWrapper<WorkerEnterEntity> enterWrapper = new LambdaUpdateWrapper<>();

                wrapper.set(teamId!=null,WorkRecordEntity::getTeamId,teamId);
                wrapper.set(teamId!=null,WorkRecordEntity::getTeamName,teamName);
                wrapper.set(workType!=null,WorkRecordEntity::getWorkType,workType);
                wrapper.set(workTypeName!=null,WorkRecordEntity::getWorkTypeName,workTypeName);
                wrapper.set(supplierId!=null,WorkRecordEntity::getSupplierId,supplierId);
                wrapper.set(supplierName!=null,WorkRecordEntity::getSupplierName,supplierName);
                wrapper.set(subContractId!=null,WorkRecordEntity::getSubContractId,subContractId);
                wrapper.set(subContractName!=null,WorkRecordEntity::getSubContractName,subContractName);
                wrapper.in(WorkRecordEntity::getId,ids);
                //回写公司
                workerEntityWrapper.set(workType!=null,WorkerEntity::getWorkType,workType);
                workerEntityWrapper.set(workTypeName!=null,WorkerEntity::getWorkTypeName,workTypeName);
                workerEntityWrapper.in(WorkerEntity::getId,workerEntities);



                enterWrapper.set(supplierId!=null,WorkerEnterEntity::getSupplierId,supplierId);
                enterWrapper.set(supplierName!=null,WorkerEnterEntity::getSupplierName,supplierName);
                enterWrapper.set(subContractId!=null,WorkerEnterEntity::getSubContractId,subContractId);
                enterWrapper.set(subContractName!=null,WorkerEnterEntity::getSubContractName,subContractName);
                enterWrapper.in(WorkerEnterEntity::getId,enterEntities);
                super.update(wrapper);
                if (workType!=null&&CollectionUtils.isNotEmpty(workerEntities)){
                    workerService.update(workerEntityWrapper);
                }
                //回写入场
                if (subContractId!=null&&CollectionUtils.isNotEmpty(enterEntities)){
                    workerEnterService.update(enterWrapper);
                }
            }
        }

        return updateVO;
    }

    @Override
    public Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        if (teamId == null && workerId == null) {
            return 0;
        }
        return baseMapper.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, workerId);
    }

    @Override
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordDataToLab(int pageNumber, int pageSize, String relyCondition, String searchText, String condition, String searchObject) throws ParseException {
        Long teamId = null;
        if (StringUtils.isNotBlank(relyCondition)) {
            teamId = Long.parseLong(relyCondition.split("=")[1]);
            ProjectTeamEntity team = projectTeamService.getById(teamId);
            if (teamId == null) {
                return CommonResponse.error("当前班组不存在档案！");
            }
            //如果是根班组不需要过滤，因为有的人员所属班组为空也在根班组下面
            teamId = team.getParentId() == null ? null : teamId;
        }
        QueryParam param = new QueryParam();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("phone");
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //查询有退场的用工记录

        // 月份
        String salaryMonth = (String) JSONObject.parseObject(condition, Map.class).get("salaryMonth");
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (conditionMap.containsKey("salaryMonth")) {
                //进场日期 退场日期 enter_date exit_date   进场日期 小于等于这个月份  退场日期 大于等于这个月份
                salaryMonth = (String) conditionMap.get("salaryMonth");
                param.getParams().put(" ", new Parameter(QueryParam.SQL, "DATE_FORMAT( enter_date, '%Y-%m' )<= '" +
                        salaryMonth + "' AND ( DATE_FORMAT( exit_date, '%Y-%m' )>= '" +
                        salaryMonth + "' OR exit_date IS NULL)"));
            }
            if (conditionMap.containsKey("projectId")) {
                param.getParams().put("project_id", new Parameter(QueryParam.EQ, conditionMap.get("projectId")));
            } else {
                param.getParams().put("org_id", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        if (teamId != null) {
            param.getParams().put("team_id", new Parameter(QueryParam.LIKE, teamId));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("enter_date", "desc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);

        IPage<WorkRecordEntity> page = super.queryPage(param, false);
        IPage<WorkRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<WorkRecordVO> recordVOS = BeanMapper.mapList(page.getRecords(), WorkRecordVO.class);


        //日期处理  HH:mm:ss
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        //计算每个月有多少天
        DateFormat df = new SimpleDateFormat("yyyy-MM");
        Date parseSalaryMonth = df.parse(salaryMonth);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(parseSalaryMonth);
        int actualMaximum = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        Date dateEnter = sdf.parse(salaryMonth + "-1");
        Date dateExit = sdf.parse(salaryMonth + "-" + actualMaximum);
        for (WorkRecordVO vo : recordVOS) {
//            如果 Date1 在 Date2 参数之后，则返回值大于0。
//            如果 Date1 在 Date2 参数之前，则返回值小于0。
            Date _dateEnter = dateEnter;
            if (vo.getEnterDate().compareTo(dateEnter) > 0) {
                _dateEnter = vo.getEnterDate();
            }
            Date _dateExit = dateExit;
            if (vo.getExitDate() != null && vo.getExitDate().compareTo(dateExit) < 0) {
                _dateExit = vo.getExitDate();
            }
            vo.setCheckingDay(attendanceService.totalAttendanceDays(_dateEnter, _dateExit, vo.getWorkerId(), vo.getProjectId()));

            vo.setCheckingDayFlag(vo.getCheckingDay()>0?1:0);
        }
        pageData.setRecords(recordVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     *  图片校验的回写 项目花名册 往公司花名册 写
     */
    void updateAttachmentCheck(WorkRecordEntity entity){
        logger.info("进入图片校验回调接口-----1");
        List<String> typeList = new ArrayList();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s :typeList){
            //1.项目花名册 是否存在
            CommonResponse<List<AttachmentVO>> idCardResponse = attachmentApi.queryListBySourceId(
                    entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            //2.存在就修改公司花名册 修改记录
            if (CollectionUtils.isNotEmpty(idCardResponse.getData())){
                logger.info("进入图片校验回调接口-----2["+s+"]");
                //3.查询公司花名册 是否存在
                CommonResponse<List<AttachmentVO>> orgIdCardResponse = attachmentApi.queryListBySourceId(
                        entity.getWorkerId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
                if (!orgIdCardResponse.isSuccess()){
                    throw new BusinessException("网络异常 查询文件中心异常");
                }
                if (CollectionUtils.isNotEmpty(orgIdCardResponse.getData())){
                    //4.公司花名册 存在就删除
                    CommonResponse<String> deleteFileByParam = attachmentApi.deleteFileByParam(
                            entity.getWorkerId(), WORKER_BILL_TYPE, s);
                    if (!deleteFileByParam.isSuccess()){
                        throw new BusinessException("网络异常 文件中心删除失败");
                    }
                }
                //5.然后写入公司花名册
                CommonResponse<String> commonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(entity.getId()), RECORD_BILL_TYPE,s ,
                        Long.toString(entity.getWorkerId()),WORKER_BILL_TYPE ,s );
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException("网络异常 文件中心复制失败");
                }
                CommonResponse<List<AttachmentVO>> orgIdCardNewResponse = attachmentApi.queryListBySourceId(
                        entity.getId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
                if (!orgIdCardNewResponse.isSuccess()){
                    throw new BusinessException("网络异常 查询文件中心异常");
                }
                if (FACE_TYPE.equals(s)&&CollectionUtils.isNotEmpty(orgIdCardNewResponse.getData())) {
                    logger.info("进入图片校验回调接口-----2");
                    // 人脸注册
                    AttachmentVO attachmentVO = orgIdCardNewResponse.getData().get(0);
                    FaceInfoVO faceInfoVO = new FaceInfoVO();
                    faceInfoVO.setUserId(entity.getWorkerId());
                    faceInfoVO.setUserName(entity.getName());
                    faceInfoVO.setIdNumber(entity.getIdCard());
                    faceInfoVO.setImgUrl(fileUrl + attachmentVO.getFilePath());
                    faceService.faceRegistration(faceInfoVO, false);
                }

            }
        }

    }

}
