package com.ejianc.business.other.henger.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.bean.HengErEquipPersonEntity;
import com.ejianc.business.other.henger.bean.HengErTaskEntity;
import com.ejianc.business.other.henger.enums.ConTypeEnum;
import com.ejianc.business.other.henger.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.IHengErEquipPersonService;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.henger.vo.HengErRecordVO;
import com.ejianc.business.other.henger.vo.HengErTaskVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiLogEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiLogService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import io.swagger.models.auth.In;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 恒尔-识别记录
 *
 * @author generator
 */
@Controller
@RequestMapping("hengErApi/records")
public class HengErRecordsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IHengErTaskService hengErTaskService;
    @Autowired
    private IAttendanceLogService attendanceLogService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IXiaoShiLogService xiaoShiLogService;
    @Autowired
    private IHengErEquipPersonService hengErEquipPersonService;
    @Autowired
    private IEquipRecordsService equipRecordsService;

    @RequestMapping(value = "/heartBeat", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject heartBeat(@RequestBody JSONObject json) {
        logger.info("心跳接受成功-------------------{}", json.toJSONString());
        JSONObject returnJsonObject = new JSONObject();

        /**
         *
         * 数据校验：
         *
         * 数据格式如下:
         * 2023年12月28日12:15:34
         * {
         * 	"data": {
         * 		"TaskId": 5,
         * 		"StateCode": 0,
         * 		"OperatorInfo": {
         * 			"operator": "AddPerson",
         * 			"SuccessCount": 1,
         * 			"ProgressText": "1/1",
         * 			"ErrCount": 0,
         * 			"errorInfo": [{
         * 				"errorcode": 0,
         * 				"errorItem": "",
         * 				"errordesc": ""
         *                        }],
         * 			"SuccessInfo": []* 		}
         *    },
         * 	"operator": "HeartBeat",
         * 	"info": {
         * 		"DeviceID": 2369912,
         * 		"Time": "2023-12-27T17:26:38"
         *    }
         * }
         */
        JSONObject info = json.getJSONObject("info");
        JSONObject data = json.getJSONObject("data");
        String operator = json.getString("operator");

        if (info == null || data == null || operator == null) {
            throw new BusinessException("协议格式不正确！");
        }
        if (data.get("TaskId") == null || data.get("StateCode") == null || data.get("OperatorInfo") == null) {
            throw new BusinessException("指令数据异常！");
        }

        Integer deviceID = info.getInteger("DeviceID");
        Integer taskId = data.getInteger("TaskId");
        Integer stateCode = data.getInteger("StateCode");

        /**
         * 如果设备空闲
         *      1回填任务结果
         *      2、根据业务类型回填数据
         *          2.1单个名单添加
         *          2.2单个名单删除 DOTO
         *          2.3单个名单查询
         */
        if (stateCode == 0) {
            HengErTaskEntity taskEntity = hengErTaskService.getOne(Wrappers.<HengErTaskEntity>lambdaQuery().eq(
                    HengErTaskEntity::getTaskId, taskId));


            if (data.get("OperatorInfo") != null) {
                JSONObject operatorInfo = data.getJSONObject("OperatorInfo");
                String operatorType = operatorInfo.getString("operator");
                /**
                 * 回填任务结果
                 */
                if (operatorInfo.get("ErrCount") != null) {
                    Integer errCount = operatorInfo.getInteger("ErrCount");

                    if (errCount == 0) {
                        hengErTaskService.update(Wrappers.<HengErTaskEntity>lambdaUpdate()
                                .set(HengErTaskEntity::getFinishFlag, "1")
                                .set(HengErTaskEntity::getReturnDate, new Date())
                                .set(HengErTaskEntity::getReturnParam, json.toJSONString())
                                .eq(HengErTaskEntity::getEquipSn, deviceID)
                                .eq(HengErTaskEntity::getTaskId, taskId)
                        );
                        logger.info("任务执行完成，taskId = {}", taskId);

                    } else {
                        hengErTaskService.update(Wrappers.<HengErTaskEntity>lambdaUpdate()
                                .set(HengErTaskEntity::getFinishFlag, "-1")
                                .set(HengErTaskEntity::getReturnDate, new Date())
                                .set(HengErTaskEntity::getReturnParam, json.toJSONString())
                                .eq(HengErTaskEntity::getEquipSn, deviceID)
                                .eq(HengErTaskEntity::getTaskId, taskId)
                        );
                        logger.info("任务返回出现错误，taskId = {}", taskId);

                    }


                }

                /**
                 *  2.1单个名单添加，如果新增人员成功，回写设备人员表
                 */
                if (operatorType.equals(ServiceTypeEnum.单个名单添加.getStatus())) {
                    Integer errCount = operatorInfo.getInteger("ErrCount");
                    if(errCount == 0){
                        String queryParam = taskEntity.getQueryParam();
                        if (StringUtils.isNotEmpty(queryParam)) {
                            JSONObject jsonObject = JSONObject.parseObject(queryParam);
                            JSONObject info1 = jsonObject.getJSONObject("info");
                            String name = info1.getString("Name");
                            Long workerId = info1.getLong("PersonUUID");
                            HengErEquipPersonEntity equipPersonEntity = new HengErEquipPersonEntity();
                            equipPersonEntity.setWorkName(name);
                            equipPersonEntity.setEquipSn(deviceID.toString());
                            equipPersonEntity.setWorkerId(workerId);
                            equipPersonEntity.setServiceDate(new Date());

                            hengErEquipPersonService.saveOrUpdate(equipPersonEntity);
                        }
                    }

                }
                /**
                 * 2.2 单个名单删除,如果删除成功，删除设备人员表
                 */
                if (operatorType.equals(ServiceTypeEnum.单个名单删除.getStatus())) {
                    Integer errCount = operatorInfo.getInteger("ErrCount");
                    if(errCount == 0){
                        String queryParam = taskEntity.getQueryParam();
                        if (StringUtils.isNotEmpty(queryParam)) {
                            JSONObject jsonObject = JSONObject.parseObject(queryParam);
                            JSONObject info1 = jsonObject.getJSONObject("info");
                            String name = info1.getString("Name");
                            Long workerId = info1.getLong("PersonUUID");


                            boolean remove = hengErEquipPersonService.remove(Wrappers.<HengErEquipPersonEntity>lambdaQuery()
                                    .eq(HengErEquipPersonEntity::getWorkerId, workerId)
                                    .eq(HengErEquipPersonEntity::getEquipSn, deviceID.toString())
                            );
                            logger.info("设备人员删除------{},设备sn----{},wokerId--{}",remove,deviceID,workerId);
                        }
                    }

                }
                /**
                 * 2.3、如果是查询，回写设备人员表
                 *      1)查询信息存在，回填最新更新时间
                 *      2)查询信息不存在，将原有数据清空。
                 */
                if (operatorType.equals(ServiceTypeEnum.单个名单查询.getStatus())) {

                    JSONArray successInfo = operatorInfo.getJSONArray("SuccessInfo");
                    HengErEquipPersonEntity equipPersonEntity = hengErEquipPersonService.selectById(taskEntity.getServiceId());

                    List<JSONObject> successJSONList = successInfo.toJavaList(JSONObject.class);
                    if (ListUtil.isNotEmpty(successJSONList)) {
                        JSONObject successJson = successJSONList.get(0).getJSONObject("info");
                        if (successJson != null) {
                            if (equipPersonEntity == null) {
                                logger.info("设备人员信息不存在，id为{}", taskEntity.getServiceId());
                            } else {
                                equipPersonEntity.setEquipSn(deviceID.toString());
                                equipPersonEntity.setBeginTime(successJson.getString("ValidBegin"));
                                equipPersonEntity.setEndTime(successJson.getString("ValidEnd"));
                                equipPersonEntity.setWorkName(successJson.getString("Name"));
                                equipPersonEntity.setServiceDate(new Date());
                                equipPersonEntity.setWorkerId(successJson.getLong("PersonUUID"));
                                hengErEquipPersonService.saveOrUpdate(equipPersonEntity);
                            }

                        }
                    } else {
                        if (equipPersonEntity == null) {
                            logger.info("设备人员信息不存在，id为{}", taskEntity.getServiceId());
                        } else {
                            hengErEquipPersonService.removeById(taskEntity.getServiceId());
                        }
                    }
                }


            }


            QueryWrapper<HengErTaskEntity> taskWrapper = new QueryWrapper<>();
            taskWrapper.eq("equip_sn", deviceID.toString());
            taskWrapper.eq("finish_flag", 2);
            taskWrapper.orderByAsc("task_id");
            taskWrapper.last("limit 1");
            List<HengErTaskEntity> hengErTaskEntities = hengErTaskService.list(taskWrapper);

            if (ListUtil.isNotEmpty(hengErTaskEntities)) {
                HengErTaskEntity hengErTaskEntity = hengErTaskEntities.get(0);
                String queryParam = hengErTaskEntity.getQueryParam();
                JSONObject operatorInfo = JSONObject.parseObject(queryParam);
                returnJsonObject.put("TimeStamp", new Date().getTime());
                returnJsonObject.put("TaskId", hengErTaskEntity.getTaskId());
                returnJsonObject.put("OperatorInfo", operatorInfo);

                /**
                 * 回填任务发送时间
                 */
                hengErTaskEntity.setSendDate(new Date());
                hengErTaskService.updateById(hengErTaskEntity);
                /**
                 * 回写日志
                 */
                XiaoShiLogEntity xiaoShiLogEntity = new XiaoShiLogEntity();
                xiaoShiLogEntity.setInputParams(returnJsonObject.toJSONString());
                xiaoShiLogEntity.setResData(json.toJSONString());
                xiaoShiLogEntity.setCreateTime(new Date());
                xiaoShiLogEntity.setLogType(ConTypeEnum.恒尔.getStatus());
                xiaoShiLogService.saveOrUpdate(xiaoShiLogEntity);
                /**
                 * 回写设备状态
                 */
                if (data.getInteger("StateCode") != null) {
                    hengErEquipService.update(Wrappers.<HengErEquipEntity>lambdaUpdate()
                            .set(HengErEquipEntity::getEquipStatus, data.getInteger("StateCode"))
                            .set(HengErEquipEntity::getEquipDate, new Date())
                            .eq(HengErEquipEntity::getEquipSn, deviceID.toString())
                            .in(HengErEquipEntity::getBillState, Arrays.asList(1, 3))
                    );
                    logger.info("同步设备信息成功!");
                }
            }


        }




        logger.info("心跳返回数据为{}", returnJsonObject.toJSONString());
        return returnJsonObject;
    }

    @RequestMapping(value = "/realTimeSyn", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject realTimeSyn(@RequestBody JSONObject json) {
        logger.info("认证结果接受成功-------------------{}", json.toJSONString());

        /**
         * 解析设备id和人员id，及识别时间
         */
        JSONObject info = json.getJSONObject("info");
        HengErRecordVO hengErRecordVO = info.toJavaObject(HengErRecordVO.class);
        String equipSn = hengErRecordVO.getDeviceID();
        Long workerId = hengErRecordVO.getPersonUUID();
        Date serviceDate = hengErRecordVO.getCreateTime();
        String verifyStatus = hengErRecordVO.getVerifyStatus();


        String name = info.getString("Name");
        /**
         * 是否是临时名单
         * 0: 永久生效名单
         * 1: 临时名单 1(起止时间段)
         * 2: 临时名单 2(每天时间段， 新数据库版本支持)
         * 3: 临时名单 3(有效次数，新数据库版本支持)
         * 4: 临时名单 4(临时名单 2 和
         * 临时名单 3 的结合，新数据库
         * 版本且中性版本 9.4 后支持)
         */
        String tempValId = info.getString("Tempvalid");

        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(equipSn);
        equipRecordsEntity.setWorkerId(workerId);
        equipRecordsEntity.setWorkerName(name);
        equipRecordsEntity.setServiceDate(serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.恒尔.getStatus());
        equipRecordsEntity.setRecordType(tempValId);
        equipRecordsService.saveOrUpdate(equipRecordsEntity);

        /**
         * 只处理允许访问的接口
         */
        if (verifyStatus.equals("1") && tempValId.equals("0")) {
            HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(equipSn);
            if (hengErEquipVO == null) {
                throw new BusinessException("设备为空！");
            }
            String punchCardType = hengErEquipVO.getEnterType().equals("1") ? "上班打卡" : "下班打卡";
            attendanceLogService.synPunchCard(workerId, hengErEquipVO.getProjectId(), punchCardType, serviceDate);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 200);
        jsonObject.put("desc", "OK");
        logger.info("认证结果处理完成-------------------{}", json.toJSONString());

        return jsonObject;
    }

    /**
     * 陌生人抓拍
     * @param json
     * @return
     */
    @RequestMapping(value = "/realTimeStrangerSyn", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject realTimeStrangerSyn(@RequestBody JSONObject json) {
        logger.info("陌生人抓拍结果接受成功-------------------{}", json.toJSONString());

        /**
         * 解析设备id和人员id，及识别时间
         */
        JSONObject info = json.getJSONObject("info");
        HengErRecordVO hengErRecordVO = info.toJavaObject(HengErRecordVO.class);
        String equipSn = hengErRecordVO.getDeviceID();
        Date serviceDate = hengErRecordVO.getCreateTime();




        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(equipSn);
        equipRecordsEntity.setWorkerName("陌生人");
        equipRecordsEntity.setServiceDate(serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.恒尔.getStatus());
        equipRecordsEntity.setRecordType("-1");
        equipRecordsEntity.setFaceImg(info.getString("SanpPic"));
        equipRecordsService.saveOrUpdate(equipRecordsEntity);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 200);
        jsonObject.put("desc", "OK");
        logger.info("陌生人抓拍结果接受成功-------------------{}", json.toJSONString());

        return jsonObject;
    }

}
