package com.ejianc.business.labor.common.exception;

import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.validation.ConstraintViolationException;

/**
 * 全局异常处理
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestControllerAdvice
public class CommonExceptionHandler {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());


	/**
	 * 入参验证异常处理
	 *
	 * @param e e
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	@ExceptionHandler(value = {MethodArgumentNotValidException.class})
	public CommonResponse<String> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
		BindingResult bindingResult = e.getBindingResult();
		StringBuilder sb = new StringBuilder("参数校验失败：");
		for (FieldError fieldError : bindingResult.getFieldErrors()) {
			sb.append(fieldError.getField()).append("：").append(fieldError.getDefaultMessage()).append(", ");
		}
		String msg = sb.toString();
		logger.error("MethodArgumentNotValidException--{}", msg);
		return CommonResponse.error(msg);
	}


	/**
	 * 非法参数异常处理
	 *
	 * @param e e
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	@ExceptionHandler(value = {IllegalArgumentException.class})
	public CommonResponse<String> illegalArgumentExceptionHandler(IllegalArgumentException e) {
		logger.error("IllegalArgumentException: ", e);
		return CommonResponse.error(e.getMessage());
	}


	/**
	 * 唯一约束异常处理
	 *
	 * @param e e
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	@ExceptionHandler(value = {ConstraintViolationException.class})
	public CommonResponse<String> constraintViolationExceptionHandler(ConstraintViolationException e) {
		logger.error("ConstraintViolationException: ", e);
		return CommonResponse.error(e.getMessage());
	}
}
