package com.ejianc.business.other.dangong.service;


import com.ejianc.business.other.dangong.vo.DanGongPersonAttendanceVO;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.dangong.vo.DanGongPublicResultVO;

import java.util.List;

/**
 * 弹弓-人脸考勤设备
 * 
 * @author Jiang
 * 
 */
public interface DanGongPersonApiService {


    /**
     * 下载白名单（获取人员列表）
     *
     * @param deviceId 设备编号
     *
     * @param productId 产品id V2.0新增,默认为1
     *
     * @param update
     *
     * 获取该时间（时间戳，例如：1583132110）之后的更新人员
     *
     * 0(默认值)，下载所有人员信息，不包含退场人员
     *
     * T（例如：1583132110） 获取T之后到当前时间的更新，包括新入场人员，T时间之后的退场人员
     *
     */
    List<DanGongPersonVO> getWorkerList(String deviceId, String productId, String update);

    /**
     *
     * @param vo
     */
    void getPhoto(DanGongPersonAttendanceVO vo);
}
