/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.service.IIdCardService;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="idCardService")
public class IdCardServiceImpl
implements IIdCardService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IFaceAndIdCardService faceAndIdCardService;

    @Override
    public IdentityCardInfoVO checkAndRecognizeIdentityCardInfo(String imageUrl, String side) {
        Assert.hasText((String)imageUrl, (String)"\u8eab\u4efd\u8bc1\u963f\u91ccoss\u5b58\u50a8\u5728\u7ebf\u5730\u5740\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)side, (String)"\u8eab\u4efd\u8bc1\u4eba\u50cf\u9762\u6216\u8005\u56fd\u5fbd\u9762\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u6821\u9a8c\u8eab\u4efd\u8bc1\u4ee5\u53ca\u8eab\u4efd\u8bc1\u4fe1\u606f\u8bc6\u522b\uff0cside={} imageUrl={}", (Object)side, (Object)imageUrl);
        CommonResponse response = this.faceAndIdCardService.recognizeIdentityCardInfo(imageUrl, side);
        if (!response.isSuccess()) {
            this.logger.info("\u8eab\u4efd\u8bc1\u4fe1\u606f\u8bc6\u522b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
            throw new BusinessException(response.getMsg());
        }
        JSONObject data = (JSONObject)response.getData();
        return (IdentityCardInfoVO)JSON.parseObject((String)data.toJSONString(), IdentityCardInfoVO.class);
    }
}

