package com.ejianc.business.labor.enums;

/**
 * 打卡异常枚举
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public enum PunchCardErrorEnum {
	VERIFICATION_CODE("校验验证码失败！"),
	UNRECOGNIZABLE("打卡失败，无法识别人脸！"),
	NO_AUTH("打卡失败，无该项目打卡权限！"),
	NO_UPLOAD_FACE_PHOTO("打卡失败，该人员人脸照片未上传！"),
	QUERY_COMPANY_FACE_PHOTO("公司花名册人脸照片查询失败！"),
	UNAVAILABLE_FACE("当前人脸不可用！"),
	NO_PRESENT_PERSON("项目无在场人员！"),
	NO_MOBILE_PHONE("当前用户在系统内未维护手机号！"),
	NO_WORKTIME_SETTING("该项目无考勤设置！"),
	NO_EXIST_IN_ROSTER("手机号在平台租户花名册中不存在！"),
	NO_SET_FACE("提示：当前用户未设置人脸信息，无法进行手机打卡，请联系项目管理人员添加；"),
	NO_SET_ATTENDANCE_SETTING("该项目未设置考勤方式!"),
	NO_PHONE_ATTENDANCE("该项目未设置公众号打卡权限!");
	private final String desc;

	PunchCardErrorEnum(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}
}
