package com.ejianc.business.labor.controller;

import com.ejianc.business.labor.bean.WorkerEnterRecordEntity;
import com.ejianc.business.labor.service.IWorkerEnterRecordService;
import com.ejianc.business.labor.vo.WorkerEnterRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;

/**
 * 劳务进场单
 *
 * @author baipengyan
 */
@RestController
@RequestMapping("workerEnterRecord")
public class WorkerEnterRecordController implements Serializable {
	private static final long serialVersionUID = 1L;
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IWorkerEnterRecordService service;

	@GetMapping("queryDetail")
	public CommonResponse<WorkerEnterRecordVO> queryDetail(@RequestParam(value = "id") Long id) {
		WorkerEnterRecordVO vo = null;
		WorkerEnterRecordEntity dbEntity = service.selectById(id);
		if (null != dbEntity) {
			vo = BeanMapper.map(dbEntity, WorkerEnterRecordVO.class);
		}
		return CommonResponse.success("查询物资总计划变更详情成功！", vo);
	}

}
