package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiRecordsEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiRecordsService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiRecordsApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiRegionApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiRecordsVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service("XiaoShiRecordsApiService")
public class XiaoShiRecordsApiServiceImpl implements XiaoShiRecordsApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private XiaoShiPublicApiService publicApiService;
    @Autowired
    private IXiaoShiRecordsService xiaoShiRecordsService;


    @Override
    public List<XiaoShiRecordsVO> getPage(Integer pageNum, Integer pageSize) {

        String apiUrl = "/base/identification/v1/getList";
        JSONObject queryParam = new JSONObject();
        queryParam.put("pageNum", pageNum);
        queryParam.put("pageSize", pageSize);
        queryParam.put("deviceSn", "");
        queryParam.put("personName", "");
        queryParam.put("startTime", "");
        queryParam.put("endTime", "");
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {
            JSONArray rows = resData.getJSONArray("rows");
            if(rows != null){
                return rows.toJavaList(XiaoShiRecordsVO.class);
            }
        }
        return null;
    }

    @Override
    public void synData() {
        /**
         * 循环调用接口查询，将查询结果保存到数据库，
         * 根据sourceId判断，如果有则更新，无则插入；
         */
        boolean flag = true;
        Integer pageNum = 1;
        int pageSize = 50;
        int synNum = 0;//同步次数
        while (flag) {
            List<XiaoShiRecordsVO> vos = getPage(pageNum, pageSize);
            if (ListUtil.isEmpty(vos)) {
                flag = false;
            } else {
                boolean b = xiaoShiRecordsService.saveOrUpdateBatch(BeanMapper.mapList(vos, XiaoShiRecordsEntity.class));
                if (b) {
                    synNum++;
                    pageNum++;
                }
                if (vos.size() != pageSize) {
                    flag = false;
                }

            }
        }
        logger.info("同步成功,共同步" + synNum + "次,每次50条数据");
    }

}
