package com.ejianc.business.labor.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 劳务工资单-用工记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_salary_detail")
public class SalaryDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="salary_id")
    private Long salaryId; // 工人工资单主表id
    @TableField(value="worker_id")
    private Long workerId; // 工人id
    @TableField(value="worker_name")
    private String workerName; // 工人
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="supplier_id")
    private Long supplierId; // 加班计量方式
    @TableField(value="supplier_name")
    private String supplierName; // 加班工作量
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="team_id")
    private String teamId; // 班组id
    @TableField(value="team_name")
    private String teamName; // 班组名称
    @TableField(value="work_type")
    private String workType; // 工种id
    @TableField(value="work_type_name")
    private String workTypeName; // 工种名称
    @TableField(value="sex")
    private Integer sex; // 性別 1:男 2:女
    @TableField(value="phone")
    private String phone; // 手机号
    @TableField(value="bank_card")
    private String bankCard; // 银行卡号
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="wages_type")
    private Integer wagesType; // 工资类型
    @TableField(value="sys_check_num")
    private Integer sysCheckNum; // 系统考勤天数
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="actual_check_num")
    private BigDecimal actualCheckNum; // 实际考勤
    @TableField(value="mny")
    private BigDecimal mny; // 金额
    @TableField(value="overtime_mny")
    private BigDecimal overtimeMny; // 加班费
    @TableField(value="deduct_mny")
    private BigDecimal deductMny; // 扣款费用
    @TableField(value="deduct_reason")
    private String deductReason; // 扣款原因
    @TableField(value="should_salary_mny")
    private BigDecimal shouldSalaryMny; // 应发工资:工作量*单价+加班工作量*单价
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source")
    private Integer source; // 来源 1：花名册 2：自制

    @TableField(value="overtime_wage")
    private BigDecimal overtimeWage; // 加班工价

    @TableField(value="overtime_hours")
    private BigDecimal overtimeHours; // 加班时长


    public BigDecimal getOvertimeHours() {
        return overtimeHours;
    }

    public void setOvertimeHours(BigDecimal overtimeHours) {
        this.overtimeHours = overtimeHours;
    }

    public BigDecimal getOvertimeWage() {
        return overtimeWage;
    }

    public void setOvertimeWage(BigDecimal overtimeWage) {
        this.overtimeWage = overtimeWage;
    }
    
    

    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }
    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getTeamId() {
        return teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public Integer getWagesType() {
        return wagesType;
    }

    public void setWagesType(Integer wagesType) {
        this.wagesType = wagesType;
    }
    public Integer getSysCheckNum() {
        return sysCheckNum;
    }

    public void setSysCheckNum(Integer sysCheckNum) {
        this.sysCheckNum = sysCheckNum;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getActualCheckNum() {
        return actualCheckNum;
    }

    public void setActualCheckNum(BigDecimal actualCheckNum) {
        this.actualCheckNum = actualCheckNum;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getOvertimeMny() {
        return overtimeMny;
    }

    public void setOvertimeMny(BigDecimal overtimeMny) {
        this.overtimeMny = overtimeMny;
    }
    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }
    public String getDeductReason() {
        return deductReason;
    }

    public void setDeductReason(String deductReason) {
        this.deductReason = deductReason;
    }
    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
    
}
