package com.ejianc.business.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labor.bean.BuildLicenseEntity;

/**
 * 项目信息
 *
 * @author generator
 */
@TableName("ejc_labor_project")
public class PorjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "contractor_corp_code")
    private String contractorCorpCode; // 总承包单位统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    @TableField(value = "contractor_corp_name")
    private String contractorCorpName; // 总承包单位名称
    @TableField(value = "name")
    private String name; // 项目名称
    @TableField(value = "description")
    private String description; // 项目简介
    @TableField(value = "category_id")
    private Long categoryId; // 项目分类id
    @TableField(value = "category_code")
    private String categoryCode; // 项目分类编码
    @TableField(value = "category_name")
    private String categoryName; // 项目分类。参见项目分类字典表
    @TableField(value = "build_corp_name")
    private String buildCorpName; // 建设单位名称
    @TableField(value = "build_corp_code")
    private String buildCorpCode; // 建设单位统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    @TableField(value = "build_plan_num")
    private String buildPlanNum; // 建设用地规划许可证编号。
    @TableField(value = "prj_plan_num")
    private String prjPlanNum; // 建设工程规划许可证编号。
    @TableField(value = "area_id")
    private String areaId; // 项目所在地id
    @TableField(value = "area_name")
    private String areaName; // 项目所在地名称
    @TableField(value = "area_code")
    private String areaCode; // 项目所在地。参考行政区划字典表
    @TableField(value = "invest")
    private BigDecimal invest; // 总投资，单位：（万元）
    @TableField(value = "building_area")
    private BigDecimal buildingArea; // 总面积，单位：平方米
    @TableField(value = "building_length")
    private BigDecimal buildingLength; // 总长度，单位：米
    @TableField(value = "start_date")
    private Date startDate; // 开工日期，精确到天，格式：yyyy-MM-dd
    @TableField(value = "complete_date")
    private Date completeDate; // 竣工日期，精确到天，格式：yyyy-MM-dd
    @TableField(value = "link_man")
    private String linkMan; // 联系人姓名
    @TableField(value = "link_phone")
    private String linkPhone; // 联系人办公电话
    @TableField(value = "prj_status_id")
    private Long prjStatusId; // 项目状态id
    @TableField(value = "prj_status_code")
    private String prjStatusCode; // 项目状态编码
    @TableField(value = "prj_status_name")
    private String prjStatusName; // 项目状态。参考项目状态字典表
    @TableField(value = "lat")
    private BigDecimal lat; // WGS84经度
    @TableField(value = "lng")
    private BigDecimal lng; // WGS84纬度
    @TableField(value = "address")
    private String address; // 项目地点
    @TableField(value = "approval_num")
    private String approvalNum; // 立项文号
    @TableField(value = "approval_level_id")
    private Long approvalLevelId; // 立项级别id
    @TableField(value = "approval_level_code")
    private String approvalLevelCode; // 立项级别编码
    @TableField(value = "approval_level_name")
    private String approvalLevelName; // 立项级别。参考立项级别字典表
    @TableField(value = "prj_size_id")
    private Long prjSizeId; // 建设规模id
    @TableField(value = "prj_size_code")
    private String prjSizeCode; // 建设规模编码
    @TableField(value = "prj_size_name")
    private String prjSizeName; // 建设规模。参考建设规模字典表
    @TableField(value = "property_num_id")
    private Long propertyNumId; // 建设性质id
    @TableField(value = "property_num_code")
    private String propertyNumCode; // 建设性质编码
    @TableField(value = "property_num_name")
    private String propertyNumName; // 建设性质。参考建设性质分类字典表
    @TableField(value = "function_num_id")
    private Long functionNumId; // 工程用途id
    @TableField(value = "function_num_code")
    private String functionNumCode; // 工程用途编码
    @TableField(value = "function_num_name")
    private String functionNumName; // 工程用途。参考工程用途字典表
    @TableField(value = "nation_num_id")
    private Long nationNumId; // 国籍地区id
    @TableField(value = "nation_num_code")
    private String nationNumCode; // 国籍地区编码
    @TableField(value = "nation_num_name")
    private String nationNumName; // 国籍或地区。参考国籍及地区字典表
    @TableField(value = "location")
    private String location; // 施工许可证颁发单位所在地行政区划编码
    @TableField(value = "org_id")
    private Long orgId; // 组织id
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "create_user_name")
    private String createUserName; // 编制人
    @TableField(value = "operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value = "operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者
    @TableField(value = "remark")
    private String remark; // 备注
    @TableField(value = "region_id")
    private String regionId;//设备位置唯一标识
    @TableField(value = "group_id")
    private String groupId;//分组唯一标识
    @TableField(value = "con_type")
    private String conType;//硬件平台
    @TableField(value = "inner_project_id")
    private Long innerProjectId;//pm项目
    @TableField(value = "build_corp_id")
    private Long buildCorpId; // 建设单位
    @TableField(value = "contractor_corp_id")
    private Long contractorCorpId; // 总承包单位
    @TableField(value = "app_id")
    private String appId;//appId
    @TableField(value = "app_key")
    private String appKey;//appKey
    @TableField(value = "app_secret")
    private String appSecret;//appSecret
    @TableField(exist = false)
    @SubEntity(serviceName = "buildLicenseService")
    private List<BuildLicenseEntity> buildLicenseList = new ArrayList<>(); // 项目施工许可证子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractorCorpCode() {
        return contractorCorpCode;
    }

    public void setContractorCorpCode(String contractorCorpCode) {
        this.contractorCorpCode = contractorCorpCode;
    }

    public String getContractorCorpName() {
        return contractorCorpName;
    }

    public void setContractorCorpName(String contractorCorpName) {
        this.contractorCorpName = contractorCorpName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getBuildCorpName() {
        return buildCorpName;
    }

    public void setBuildCorpName(String buildCorpName) {
        this.buildCorpName = buildCorpName;
    }

    public String getBuildCorpCode() {
        return buildCorpCode;
    }

    public void setBuildCorpCode(String buildCorpCode) {
        this.buildCorpCode = buildCorpCode;
    }

    public String getBuildPlanNum() {
        return buildPlanNum;
    }

    public void setBuildPlanNum(String buildPlanNum) {
        this.buildPlanNum = buildPlanNum;
    }

    public String getPrjPlanNum() {
        return prjPlanNum;
    }

    public void setPrjPlanNum(String prjPlanNum) {
        this.prjPlanNum = prjPlanNum;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public BigDecimal getInvest() {
        return invest;
    }

    public void setInvest(BigDecimal invest) {
        this.invest = invest;
    }

    public BigDecimal getBuildingArea() {
        return buildingArea;
    }

    public void setBuildingArea(BigDecimal buildingArea) {
        this.buildingArea = buildingArea;
    }

    public BigDecimal getBuildingLength() {
        return buildingLength;
    }

    public void setBuildingLength(BigDecimal buildingLength) {
        this.buildingLength = buildingLength;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getCompleteDate() {
        return completeDate;
    }

    public void setCompleteDate(Date completeDate) {
        this.completeDate = completeDate;
    }

    public String getLinkMan() {
        return linkMan;
    }

    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    public Long getPrjStatusId() {
        return prjStatusId;
    }

    public void setPrjStatusId(Long prjStatusId) {
        this.prjStatusId = prjStatusId;
    }

    public String getPrjStatusCode() {
        return prjStatusCode;
    }

    public void setPrjStatusCode(String prjStatusCode) {
        this.prjStatusCode = prjStatusCode;
    }

    public String getPrjStatusName() {
        return prjStatusName;
    }

    public void setPrjStatusName(String prjStatusName) {
        this.prjStatusName = prjStatusName;
    }

    public BigDecimal getLat() {
        return lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public BigDecimal getLng() {
        return lng;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getApprovalNum() {
        return approvalNum;
    }

    public void setApprovalNum(String approvalNum) {
        this.approvalNum = approvalNum;
    }

    public Long getApprovalLevelId() {
        return approvalLevelId;
    }

    public void setApprovalLevelId(Long approvalLevelId) {
        this.approvalLevelId = approvalLevelId;
    }

    public String getApprovalLevelCode() {
        return approvalLevelCode;
    }

    public void setApprovalLevelCode(String approvalLevelCode) {
        this.approvalLevelCode = approvalLevelCode;
    }

    public String getApprovalLevelName() {
        return approvalLevelName;
    }

    public void setApprovalLevelName(String approvalLevelName) {
        this.approvalLevelName = approvalLevelName;
    }

    public Long getPrjSizeId() {
        return prjSizeId;
    }

    public void setPrjSizeId(Long prjSizeId) {
        this.prjSizeId = prjSizeId;
    }

    public String getPrjSizeCode() {
        return prjSizeCode;
    }

    public void setPrjSizeCode(String prjSizeCode) {
        this.prjSizeCode = prjSizeCode;
    }

    public String getPrjSizeName() {
        return prjSizeName;
    }

    public void setPrjSizeName(String prjSizeName) {
        this.prjSizeName = prjSizeName;
    }

    public Long getPropertyNumId() {
        return propertyNumId;
    }

    public void setPropertyNumId(Long propertyNumId) {
        this.propertyNumId = propertyNumId;
    }

    public String getPropertyNumCode() {
        return propertyNumCode;
    }

    public void setPropertyNumCode(String propertyNumCode) {
        this.propertyNumCode = propertyNumCode;
    }

    public String getPropertyNumName() {
        return propertyNumName;
    }

    public void setPropertyNumName(String propertyNumName) {
        this.propertyNumName = propertyNumName;
    }

    public Long getFunctionNumId() {
        return functionNumId;
    }

    public void setFunctionNumId(Long functionNumId) {
        this.functionNumId = functionNumId;
    }

    public String getFunctionNumCode() {
        return functionNumCode;
    }

    public void setFunctionNumCode(String functionNumCode) {
        this.functionNumCode = functionNumCode;
    }

    public String getFunctionNumName() {
        return functionNumName;
    }

    public void setFunctionNumName(String functionNumName) {
        this.functionNumName = functionNumName;
    }

    public Long getNationNumId() {
        return nationNumId;
    }

    public void setNationNumId(Long nationNumId) {
        this.nationNumId = nationNumId;
    }

    public String getNationNumCode() {
        return nationNumCode;
    }

    public void setNationNumCode(String nationNumCode) {
        this.nationNumCode = nationNumCode;
    }

    public String getNationNumName() {
        return nationNumName;
    }

    public void setNationNumName(String nationNumName) {
        this.nationNumName = nationNumName;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    public List<BuildLicenseEntity> getBuildLicenseList() {
        return buildLicenseList;
    }

    public void setBuildLicenseList(List<BuildLicenseEntity> buildLicenseList) {
        this.buildLicenseList = buildLicenseList;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getConType() {
        return conType;
    }

    public void setConType(String conType) {
        this.conType = conType;
    }

    public Long getInnerProjectId() {
        return innerProjectId;
    }

    public void setInnerProjectId(Long innerProjectId) {
        this.innerProjectId = innerProjectId;
    }

    public Long getBuildCorpId() {
        return buildCorpId;
    }

    public void setBuildCorpId(Long buildCorpId) {
        this.buildCorpId = buildCorpId;
    }

    public Long getContractorCorpId() {
        return contractorCorpId;
    }

    public void setContractorCorpId(Long contractorCorpId) {
        this.contractorCorpId = contractorCorpId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }
}
