package com.ejianc.business.desktop.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.AttendancePerLineVO;
import com.ejianc.business.desktop.vo.TypeVO;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IUnAttendanceService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * @Author: jiang
 * @Date: 2024/1/25 15:49
 **/
@Controller
@RequestMapping("deskTop")
public class DeskTopController {
    @Resource
    private IOrgApi iOrgApi;

    @Autowired
    private IUnAttendanceService unAttendanceService;

    @Autowired
    private IAttendanceService attendanceService;

    @Autowired
    private IWorkRecordService workRecordService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    /**
     * @Description queryAttendancePerLine
     *      门户-按时间查询考勤率
     * @param param
     */
    @RequestMapping(value = "/queryAttendancePerLine", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<AttendancePerLineVO>> queryAttendancePerLine(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("parentOrgName");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        List<OrgVO> orgVOList = null;

        /** 组织隔离 */
        if (param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        param.getParams().put("dr",new Parameter(QueryParam.IN, 0));

        /** 分页查询 */
        QueryWrapper<AttendanceVO> wrapper = changeToQueryWrapper(param);

        List<AttendancePerLineVO> vos = attendanceService.queryAttendancePerLine(wrapper);
        if(ListUtil.isNotEmpty(vos)){
            QueryWrapper<WorkRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("enter_exit_state",1);
            queryWrapper.in("org_id",commonOrgIds);
            List<WorkRecordEntity> list = workRecordService.list(queryWrapper);
            for (AttendancePerLineVO vo : vos) {
                if(DateUtil.isSameDay(vo.getPunchCardDate(),new Date())){
                    vo.setTotalNum(list.size());
                }
                BigDecimal attendancePer  = BigDecimal.ZERO;
                if(vo.getAttendanceNum() != null && vo.getTotalNum() != null){
                    BigDecimal attendanceB = new BigDecimal(vo.getAttendanceNum());
                    BigDecimal totalB = new BigDecimal(vo.getTotalNum());
                    if(totalB.compareTo(attendancePer) == 0){
                        attendancePer = BigDecimal.ONE;
                    } else {
                        attendancePer = attendanceB.divide(totalB,4,BigDecimal.ROUND_HALF_UP);

                    }
                    vo.setAttendancePer(attendancePer);
                }
            }
        }


        return CommonResponse.success("查询列表数据成功！", vos);

    }


    /**
     * @Description queryUserType
     *      门户-根据传递过来的groupCode分组统计人员类型
     * @param param
     */
    @RequestMapping(value = "/queryUserTypeByGroupCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryUserTypeByGroupCode(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        List<OrgVO> orgVOList = null;

        /** 组织隔离 */
        if (param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        param.getParams().put("dr",new Parameter(QueryParam.IN, 0));
        param.getParams().put("enterExitState",new Parameter(QueryParam.EQ, 1));


        /**
         * 支持分组的字段校验
         */
        List<String> groupCodeList = new ArrayList<>();
        groupCodeList.add("person_type");//人员类型
        groupCodeList.add("inner_type");//内外部人员
        groupCodeList.add("culture_level_type");//文化程度
        groupCodeList.add("work_role");//工人类型
            groupCodeList.add("work_type");//工种


        String groupCode = null;
        String groupName = null;
        if(param.getParams().get("groupCode") != null && param.getParams().get("groupName") != null){
            groupCode = param.getParams().get("groupCode").getValue().toString();
            groupName = param.getParams().get("groupName").getValue().toString();
            param.getParams().remove("groupCode");
            param.getParams().remove("groupName");


            if(!groupCodeList.contains(groupCode)){
                logger.info("传递分组参数异常");
                return CommonResponse.error("系统错误！");

            }
        }

        QueryWrapper<WorkRecordEntity> wrapper = changeToQueryWrapper(param);
        wrapper.groupBy(groupCode);
        wrapper.select(groupCode+" as type,"+groupName+" as typeName,count(*) as value");
        List<Map<String, Object>> maps = workRecordService.listMaps(wrapper);
        return CommonResponse.success("查询列表数据成功！", maps);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
