package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.*;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.bean.HengErTaskEntity;
import com.ejianc.business.other.henger.enums.ConTypeEnum;
import com.ejianc.business.other.henger.enums.EquipStatusEnum;
import com.ejianc.business.other.henger.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.HengErPersonApiService;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.business.other.yufan.service.YuFanPersonApiService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("workerExit") 
public class WorkerExitBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IWorkRecordService workRecordService;

	@Autowired
	private IWorkerService workerService;
	@Autowired
	private IWorkerExitService service;
	@Autowired
	private ISalaryService salaryService;
	@Resource
	private IWorkerEnterService workerEnterService;
	@Autowired
	private IHengErEquipService hengErEquipService;
	@Autowired
	private IHengErTaskService hengErTaskService;
	@Autowired
	private HengErPersonApiService hengErPersonApiService;
	@Autowired
	private YuFanPersonApiService yuFanPersonApiService;
	@Autowired
	private IPorjectService porjectService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		WorkerExitEntity workerExitEntity = service.selectById(billId);
		List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
		List<Long> workerIds = new ArrayList<>();

		Long projectId = workerExitEntity.getProjectId();
		PorjectEntity porjectEntity = porjectService.selectById(projectId);

		if (CollectionUtils.isNotEmpty(workerExitDetailList)){
			for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
				workerIds.add(workerExitDetailEntity.getWorkerId());
				LambdaUpdateWrapper<WorkRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.eq(WorkRecordEntity::getProjectId,workerExitEntity.getProjectId());
				updateWrapper.eq(WorkRecordEntity::getWorkerId,workerExitDetailEntity.getWorkerId());
				updateWrapper.eq(WorkRecordEntity::getLastFlag,1);
				updateWrapper.set(WorkRecordEntity::getEnterExitState,0);
				updateWrapper.set(WorkRecordEntity::getExitDate,workerExitDetailEntity.getExitDate());
				workRecordService.update(updateWrapper);

				// 退场日期回写最新的用功记录对应的进场单
				LambdaQueryWrapper<WorkRecordEntity> wrapper = Wrappers.<WorkRecordEntity>lambdaQuery()
						.eq(WorkRecordEntity::getProjectId, workerExitEntity.getProjectId())
						.eq(WorkRecordEntity::getWorkerId, workerExitDetailEntity.getWorkerId())
						.eq(WorkRecordEntity::getLastFlag, 1);
				WorkRecordEntity workRecordEntity = workRecordService.getOne(wrapper);
				if (workRecordEntity != null && workRecordEntity.getSourceFlag() == 1 && workRecordEntity.getSourceId() != null) {
					WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(workRecordEntity.getSourceId());
					if (workerEnterEntity != null) {
						workerEnterEntity.setExitDate(workerExitDetailEntity.getExitDate());
						workerEnterService.updateById(workerEnterEntity);
					}
				}

				//公司花名册是否回写 进场状态
				LambdaUpdateWrapper<WorkerEntity> workerWrapper = new LambdaUpdateWrapper<>();
				workerWrapper.eq(WorkerEntity::getId,workerExitDetailEntity.getWorkerId());
				workerWrapper.set(WorkerEntity::getWorkState,0); //0未入场
				workerService.update(workerWrapper);




				//删除同步第三方的数据

				if(porjectEntity.getConType().equals(ConTypeEnum.恒尔.getStatus())){
					List<HengErEquipEntity> equipEntities = hengErEquipService.list(Wrappers.<HengErEquipEntity>lambdaQuery()
							.eq(HengErEquipEntity::getProjectId, projectId)
							.ne(HengErEquipEntity::getEquipStatus, EquipStatusEnum.未同步)
							.in(HengErEquipEntity::getBillState, Arrays.asList(1,3)));
					if(ListUtil.isNotEmpty(equipEntities)){
						for (HengErEquipEntity hengErEquipEntity : equipEntities) {
							/**
							 * 获取指令
							 */
							JSONObject serviceRequest = hengErPersonApiService.getDelCom(workerExitDetailEntity, hengErEquipEntity.getEquipSn());

							/**
							 * 构建任务队列
							 */
							hengErTaskService.addTaskByType(
									hengErEquipEntity.getEquipSn(),
									workerExitDetailEntity.getId(),
									ServiceTypeEnum.单个名单添加.getStatus(),
									serviceRequest.toJSONString());
						}
					}
				}




			}
		}

		if(porjectEntity.getConType().equals(ConTypeEnum.宇泛.getStatus())){
			List<WorkRecordEntity> list = workRecordService.list(Wrappers.<WorkRecordEntity>lambdaQuery()
					.eq(WorkRecordEntity::getProjectId, projectId)
					.in(WorkRecordEntity::getWorkerId, workerIds)
			);
			String sns = list.stream().filter(s->s.getSn() != null).map(WorkRecordEntity::getSn).collect(Collectors.joining(","));

			if(StringUtils.isNotEmpty(sns)){
				if(sns.length() >= 100){
					for (WorkRecordEntity workRecordEntity : list) {
						yuFanPersonApiService.deletePerson(workRecordEntity.getSn(),projectId);
					}
				} else {
					yuFanPersonApiService.deletePerson(sns,projectId);
				}

			}


		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		WorkerExitEntity workerExitEntity = service.selectById(billId);
		List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
		if (CollectionUtils.isNotEmpty(workerExitDetailList)){
			for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
				QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
				objectQueryWrapper.eq("project_id",workerExitEntity.getProjectId());
				objectQueryWrapper.eq("worker_id",workerExitDetailEntity.getWorkerId());
				objectQueryWrapper.eq("enter_exit_state",1);
				List<WorkRecordEntity> list = workRecordService.list(objectQueryWrapper);
				if (CollectionUtils.isNotEmpty(list)){
					String err="姓名:"+workerExitDetailEntity.getWorkerName()+",已经进场,不支持弃审";
				    return CommonResponse.error(err);
				}
				/**
				 * 之后该人员是否有工资单
				 */
				String exitDate = EJCDateUtil.format(workerExitDetailEntity.getExitDate(), EJCDateUtil.MONTH);
				Integer con=salaryService.haveSalaryFlag(workerExitDetailEntity.getWorkerId(),exitDate);
			    if (con>1){
					String err="姓名:"+workerExitDetailEntity.getWorkerName()+",已经有工资单,不支持弃审";
					return CommonResponse.error(err);
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		WorkerExitEntity workerExitEntity = service.selectById(billId);
		List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
		if (CollectionUtils.isNotEmpty(workerExitDetailList)){
			for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
				LambdaUpdateWrapper<WorkRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.eq(WorkRecordEntity::getProjectId,workerExitEntity.getProjectId());
				updateWrapper.eq(WorkRecordEntity::getWorkerId,workerExitDetailEntity.getWorkerId());
				updateWrapper.eq(WorkRecordEntity::getLastFlag,1);
				updateWrapper.set(WorkRecordEntity::getEnterExitState,1);
				updateWrapper.set(WorkRecordEntity::getExitDate,null);
				workRecordService.update(updateWrapper);

				// 退场日期回写最新的用功记录对应的进场单
				LambdaQueryWrapper<WorkRecordEntity> wrapper = Wrappers.<WorkRecordEntity>lambdaQuery()
						.eq(WorkRecordEntity::getProjectId, workerExitEntity.getProjectId())
						.eq(WorkRecordEntity::getWorkerId, workerExitDetailEntity.getWorkerId())
						.eq(WorkRecordEntity::getLastFlag, 1);
				WorkRecordEntity workRecordEntity = workRecordService.getOne(wrapper);
				if (workRecordEntity != null && workRecordEntity.getSourceFlag() == 1 && workRecordEntity.getSourceId() != null) {
					WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(workRecordEntity.getSourceId());
					if (workerEnterEntity != null) {
						workerEnterEntity.setExitDate(null);
						workerEnterService.updateById(workerEnterEntity);
					}
				}

				//公司花名册是否回写 进场状态
				LambdaUpdateWrapper<WorkerEntity> workerWrapper = new LambdaUpdateWrapper<>();
				workerWrapper.eq(WorkerEntity::getId,workerExitDetailEntity.getWorkerId());
				workerWrapper.set(WorkerEntity::getWorkState,1); //0未入场
				workerService.update(workerWrapper);
			}
		}
		return CommonResponse.success();
	}

}
