/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.yufan.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.enums.ConTypeEnum;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.business.other.yufan.service.YuFanEquipApiService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="YuFanEquipApiService")
public class YuFanEquipApiServiceImpl
implements YuFanEquipApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private YuFanPublicApiService publicApiService;
    @Autowired
    private IEquipRecordsService equipRecordsService;
    @Autowired
    private IAttendanceLogService attendanceLogService;
    @Autowired
    private IWorkRecordService workRecordService;

    @Override
    public JSONArray getEquipPage(Integer pageNum, Integer pageSize, Long projectId) {
        String apiUrl = "/v2/device/page";
        JSONObject queryParam = new JSONObject();
        queryParam.put("index", (Object)pageNum);
        queryParam.put("pageSize", (Object)pageSize);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam, projectId);
        if (resData != null) {
            JSONArray content = resData.getJSONArray("content");
            this.logger.info("\u8f6c\u6362\u6570\u636e\u4e3a" + content);
            return content;
        }
        return null;
    }

    @Override
    public JSONArray addEquip(HengErEquipEntity hengErEquipEntity) {
        String apiUrl = "/v2/device/create";
        JSONObject queryParam = new JSONObject();
        queryParam.put("name", (Object)hengErEquipEntity.getEquipName());
        queryParam.put("source", (Object)"000000");
        queryParam.put("deviceNo", (Object)hengErEquipEntity.getEquipSn());
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam, hengErEquipEntity.getProjectId());
        if (resData != null) {
            JSONArray content = resData.getJSONArray("content");
            this.logger.info("\u8f6c\u6362\u6570\u636e\u4e3a" + content);
            return content;
        }
        return null;
    }

    @Override
    public JSONArray callBackEquipRecordData(JSONObject data) {
        String deviceNo = data.getString("deviceNo");
        String admitGuid = data.getString("admitGuid");
        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(deviceNo);
        equipRecordsEntity.setPersonSn(admitGuid);
        equipRecordsEntity.setWorkerName(data.getString("admitName"));
        long showTime = data.getLongValue("showTime");
        Date serviceDate = new Date(showTime);
        equipRecordsEntity.setServiceDate(serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.\u5b87\u6cdb.getStatus());
        int type = data.getIntValue("type");
        equipRecordsEntity.setRemark(type == 1 ? "\u6bd4\u5bf9\u6210\u529f" : "\u6bd4\u5bf9\u5931\u8d25");
        this.equipRecordsService.saveOrUpdate((Object)equipRecordsEntity);
        if (type == 1) {
            HengErEquipVO hengErEquipVO = this.hengErEquipService.selectByEquipSn(deviceNo);
            List list = this.workRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(WorkRecordEntity::getSn, (Object)admitGuid));
            if (hengErEquipVO == null) {
                throw new BusinessException("\u5b87\u6cdb\u8bbe\u5907\u4e3a\u7a7a\uff01" + deviceNo);
            }
            if (ListUtil.isEmpty((List)list)) {
                throw new BusinessException("\u5b87\u6cdb\u4eba\u5458\u4e3a\u7a7a\uff01" + admitGuid);
            }
            String punchCardType = hengErEquipVO.getEnterType().equals("1") ? "\u4e0a\u73ed\u6253\u5361" : "\u4e0b\u73ed\u6253\u5361";
            this.attendanceLogService.synPunchCard(((WorkRecordEntity)((Object)list.get(0))).getWorkerId(), hengErEquipVO.getProjectId(), punchCardType, serviceDate);
        }
        return null;
    }
}

