/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.mapper.SalarySlipMapper;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.vo.SalarySlipVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service(value="salarySlipService")
public class SalarySlipServiceImpl
extends BaseServiceImpl<SalarySlipMapper, SalarySlipEntity>
implements ISalarySlipService {
    @Override
    public List<SalarySlipVO> querySalarySlipVOPage(QueryWrapper wrapper, String salaryMonth, Page<SalarySlipVO> page) {
        return ((SalarySlipMapper)this.baseMapper).querySalarySlipVOPage(wrapper, salaryMonth, page);
    }

    @Override
    public List<SalarySlipVO> queryTeamSalarySlipList(QueryWrapper wrapper, String salaryMonth, Page<SalarySlipVO> page, List<String> teamIds) {
        return ((SalarySlipMapper)this.baseMapper).queryTeamSalarySlipList(wrapper, salaryMonth, page, teamIds);
    }

    @Override
    public List<SalarySlipVO> querySalarySlipDataPage(Long contractId, Long projectId, QueryWrapper wrapper, Page<SalarySlipVO> page, String contractFlag) {
        return ((SalarySlipMapper)this.baseMapper).querySalarySlipDataPage(contractId, projectId, wrapper, page, contractFlag);
    }

    @Override
    public SalarySlipVO getContractSumSalary(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List entityList = super.queryList(param, false);
        SalarySlipVO vo = new SalarySlipVO();
        BigDecimal sumShouldSalaryMny = entityList.stream().map(SalarySlipEntity::getShouldSalaryMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumAlreadyApplyMny = entityList.stream().map(SalarySlipEntity::getAlreadyApplyMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setShouldSalaryMny(sumShouldSalaryMny);
        vo.setAlreadyApplyMny(sumAlreadyApplyMny);
        return vo;
    }

    @Override
    public List<WorkRecordVO> queryWorkByTeamId(Long projectId, List<Long> teamIds) {
        return ((SalarySlipMapper)this.baseMapper).queryWorkByTeamId(projectId, teamIds);
    }
}

