/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.dangong.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.DanGongPersonAttendanceVO;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.dangong.vo.DanGongPublicResultVO;
import com.ejianc.business.other.dangong.vo.DanGongResultUtils;
import com.ejianc.business.other.enums.ConTypeEnum;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"danGongPerson"})
public class DanGongPersonController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DanGongPersonApiService danGongPersonApiService;
    @Autowired
    private IEquipRecordsService equipRecordsService;
    @Autowired
    private IAttendanceLogService attendanceLogService;
    @Autowired
    private IHengErEquipService hengErEquipService;

    @RequestMapping(value={"/init"}, method={RequestMethod.GET})
    @ResponseBody
    public String init(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="productId") String productId, @RequestParam(value="mac") String mac, @RequestParam(value="porttype") String porttype) {
        this.logger.info("\u5f39\u5f13\u521d\u59cb\u5316\u914d\u7f6e");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dgBaseInfo", (Object)new JSONObject());
        jsonObject.put("setting", (Object)new JSONObject());
        this.logger.info("\u5f39\u5f13\u521d\u59cb\u5316\u914d\u7f6e\u8fd4\u56de\u7ed3\u679c{}", (Object)JSONObject.toJSONString((Object)DanGongResultUtils.success((String)"init", (Object)jsonObject)));
        return JSONObject.toJSONString((Object)DanGongResultUtils.success((String)"init", (Object)jsonObject));
    }

    @RequestMapping(value={"/workers"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String workers(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="productId") String productId, @RequestParam(value="update", required=false) String update) {
        this.logger.info("\u5f39\u5f13\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5f00\u59cb, deviceId: {}, productId: {}, update: {}", new Object[]{deviceId, productId, update});
        try {
            List<DanGongPersonVO> workerList = this.danGongPersonApiService.getWorkerList(deviceId, productId, update);
            String result = JSON.toJSONString((Object)DanGongResultUtils.success((String)"workers", workerList), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            this.logger.info("\u5f39\u5f13\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u7ed3\u679c: {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5f02\u5e38: ", (Throwable)e);
            return JSON.toJSONString((Object)DanGongResultUtils.fail((int)-1, (String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25"));
        }
    }

    @RequestMapping(value={"/photo"}, method={RequestMethod.POST})
    @ResponseBody
    public DanGongPublicResultVO photo(@RequestBody DanGongPersonAttendanceVO body) {
        this.logger.info("\u5f39\u5f13\u83b7\u53d6\u8003\u52e4\u6570\u636e\u5f00\u59cb");
        this.logger.info("\u5f39\u5f13\u83b7\u53d6\u8003\u52e4\u4fe1\u606f\u7ed3\u679c{}", (Object)JSONObject.toJSONString((Object)body));
        String time = body.getTime();
        DateTime serviceDate = DateUtil.date((long)Long.parseLong(time));
        String deviceId = body.getDeviceId();
        Long workerId = Long.parseLong(body.getWorkerId());
        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(deviceId);
        equipRecordsEntity.setWorkerId(workerId);
        equipRecordsEntity.setServiceDate((Date)serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.\u6052\u5c14\u5f39\u5f13.getStatus());
        this.equipRecordsService.saveOrUpdate((Object)equipRecordsEntity);
        HengErEquipVO hengErEquipVO = this.hengErEquipService.selectByEquipSn(deviceId);
        if (hengErEquipVO == null) {
            throw new BusinessException("\u8bbe\u5907\u4e3a\u7a7a\uff01");
        }
        String punchCardType = "1".equals(hengErEquipVO.getEnterType()) ? "\u4e0a\u73ed\u6253\u5361" : "\u4e0b\u73ed\u6253\u5361";
        this.attendanceLogService.synPunchCard(workerId, hengErEquipVO.getProjectId(), punchCardType, (Date)serviceDate);
        this.logger.info("\u5f39\u5f13\u83b7\u53d6\u8003\u52e4\u6570\u636e\u7ed3\u675f");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("path", (Object)"");
        return DanGongResultUtils.success((String)"photo", (Object)jsonObject);
    }
}

