package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.AttendancePerLineVO;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.mapper.AttendanceMapper;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


/**
 * 考勤记录
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Service("attendanceService")
public class AttendanceServiceImpl extends BaseServiceImpl<AttendanceMapper, AttendanceEntity> implements IAttendanceService {

    @Autowired
    private IProjectApi projectApi;

    @Override
    public int totalAttendanceDays(Date enterDate, Date exitDate, Long workerId,Long projectId) {
        QueryWrapper<AttendanceEntity> queryWrapper = new QueryWrapper<>();

        queryWrapper.eq("project_id",projectId);

        queryWrapper.eq("worker_id",workerId);
//        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.between("punch_card_date",enterDate,exitDate);
        int count = super.count(queryWrapper);
        return count;
    }


    /**
     * 按个人统计分页查询
     *
     * @param p       分页
     * @param wrapper 条件构造器
     *
     * @param startDate
     * @param endDate
     * @return {@link IPage}<{@link AttendanceEntity}>
     */
    @Override
    public IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, QueryWrapper<AttendanceEntity> wrapper, String startDate, String endDate) {
        return baseMapper.queryPageByPerson(p, wrapper, startDate, endDate);
    }

    @Override
    public Integer queryAttendanceOrgIds(String orgIds){
        return baseMapper.queryAttendanceOrgIds(orgIds);
    }

    @Override
    public IPage<AttendanceVO> queryDailyAttendancePage(Page<AttendanceVO> p, QueryWrapper<AttendanceVO> wrapper) {
        return baseMapper.queryDailyAttendancePage(p, wrapper);
    }

    @Override
    public List<AttendanceVO> queryDailyAttendanceList(QueryWrapper<AttendanceVO> wrapper) {
        return baseMapper.queryDailyAttendanceList(wrapper);
    }
    @Override
    public IPage<AttendanceVO> queryAllAttendanceRecord(Page<AttendanceVO> p,QueryWrapper<AttendanceVO> wrapper) {
        return baseMapper.queryAllAttendanceRecord(p,wrapper);
    }

    @Override
    public List<AttendancePerLineVO> queryAttendancePerLine(QueryWrapper<AttendanceVO> wrapper) {
        return baseMapper.queryAttendancePerLine(wrapper);
    }
}
