package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.labor.bean.WorkerEnterChangeEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEnterRecordEntity;
import com.ejianc.business.labor.service.IWorkerEnterChangeService;
import com.ejianc.business.labor.service.IWorkerEnterRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service("workerEnterChange")
public class WorkerEnterChangeBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IWorkerService workerService;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IWorkerEnterChangeService service;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IWorkerEnterService workerEnterService;
	@Autowired
	private IWorkerEnterRecordService workerEnterRecordService;
	@Autowired
	private IAttachmentApi attachmentApi;

	private static final String ENTER_BILL_TYPE = "BT202211000003";//劳务进场 billType
	private static final String CHANGE_BILL_TYPE = "BT202304000001";//劳务进场单-变更 billType
	private static final String CHANGE_RECORD_BILL_TYPE = "BT202304000002";//劳务进场单-变更记录 billType

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 *
	 * @param
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 *
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("终审审核完回调：劳务进场单-变更单据id：{}，单据状态：{}，单据类型：{}", billId, state, billTypeCode);
		WorkerEnterChangeEntity entity = service.selectById(billId);
		if (entity == null) {
			return CommonResponse.error("单据不存在");
		}

		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			entity.setCommitDate(new Date());
		}
		UserContext userContext = sessionManager.getUserContext();
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());
		entity.setEffectiveDate(new Date());

		// 生成变更记录
		WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(entity.getWorkerEnterId());
		if (workerEnterEntity == null) {
			throw new BusinessException("劳务进场单不存在");
		}
		WorkerEnterRecordEntity recordEntity = BeanMapper.map(workerEnterEntity, WorkerEnterRecordEntity.class);
		recordEntity.setWorkerEnterId(workerEnterEntity.getId());
		Long recordId = IdWorker.getId();
		recordEntity.setId(recordId);
		recordEntity.setCreateUserCode(entity.getCreateUserCode());
		recordEntity.setCreateTime(entity.getCreateTime());
		recordEntity.setUpdateTime(entity.getUpdateTime());
		recordEntity.setUpdateUserCode(entity.getUpdateUserCode());
		recordEntity.setCurChangingId(workerEnterEntity.getCurChangingId());
		recordEntity.setChangeReason(entity.getChangeReason());
		recordEntity.setEffectiveDate(entity.getEffectiveDate());
		workerEnterRecordService.saveOrUpdate(recordEntity, false);
		logger.info("生成变更记录完成");

		// 生成变更记录附件信息
		CommonResponse<List<AttachmentVO>> response = attachmentApi.copyFiles(workerEnterEntity.getId().toString(), ENTER_BILL_TYPE, null, recordId.toString(), CHANGE_RECORD_BILL_TYPE, null, true);
		if (!response.isSuccess()) {
			throw new BusinessException(response.getMsg());
		}
		logger.info("生成变更记录附件信息完成");

		// 更新变更单据状态
		service.saveOrUpdate(entity, false);
		logger.info("更新变更单据状态完成");

		// 回写原单据
		WorkerEnterEntity workerEnter = BeanMapper.map(entity, WorkerEnterEntity.class);
		workerEnter.setChangeState(WorkerEnterVO.CHANGE_STATE_CHANGED);
		workerEnter.setCurChangingId(null);

		workerEnter.setCreateUserCode(workerEnterEntity.getCreateUserCode());
		workerEnter.setCreateTime(workerEnterEntity.getCreateTime());
		workerEnter.setId(workerEnterEntity.getId());
		workerEnter.setDr(workerEnterEntity.getDr());
		workerEnter.setVersion(workerEnterEntity.getVersion());
		workerEnter.setChangeVersion(entity.getChangeVersion());
		workerEnter.setBillState(workerEnterEntity.getBillState());

		workerEnterService.saveOrUpdate(workerEnter, false);
		logger.info("回写原单据完成");

		// 变更单据附件回写原单据
		CommonResponse<List<AttachmentVO>> response1 = attachmentApi.copyFiles(entity.getId().toString(), CHANGE_BILL_TYPE, null, workerEnterEntity.getId().toString(), ENTER_BILL_TYPE, null, true);
		if (!response1.isSuccess()) {
			throw new BusinessException(response1.getMsg());
		}
		logger.info("变更单据附件回写原单据完成");

		// 原有推送逻辑
		WorkerEnterEntity workerEnter1 = workerEnterService.selectById(entity.getWorkerEnterId());
		workerEnterService.bpmWriteBackAndInsert(workerEnter1);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		/*logger.info("弃审后事件回调：劳务进场单-变更单据id：{}，单据状态：{}，单据类型：{}", billId, state, billTypeCode);
		WorkerEnterChangeEntity entity = service.selectById(billId);
		if (entity == null) {
			return CommonResponse.error("单据不存在");
		}

		//清空变更提交人信息
		entity.setCommitUserName(null);
		entity.setCommitUserCode(null);
		entity.setCommitDate(null);

		QueryWrapper<WorkerEnterRecordEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("cur_changing_id", billId);
		WorkerEnterRecordEntity workerEnterRecord = workerEnterRecordService.getOne(wrapper);

		if (workerEnterRecord != null) {
			// 数据恢复
			WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(entity.getWorkerEnterId());
			if (workerEnterEntity == null) {
				throw new BusinessException("劳务进场单不存在");
			}
			WorkerEnterEntity workerEnter = null;
			workerEnter = BeanMapper.map(workerEnterRecord, WorkerEnterEntity.class);
			workerEnter.setCurChangingId(workerEnterRecord.getCurChangingId());

			//恢复创建人等信息
			workerEnter.setCreateUserCode(workerEnterEntity.getCreateUserCode());
			workerEnter.setCreateTime(workerEnterEntity.getCreateTime());
			workerEnter.setId(workerEnterEntity.getId());
			workerEnter.setVersion(workerEnterEntity.getVersion());

			// 变更状态-变更中
			workerEnter.setChangeState(WorkerEnterVO.CHANGE_STATE_UNCHANGED);
			workerEnter.setChangeVersion(entity.getChangeVersion() - 1);

			workerEnterService.saveOrUpdate(workerEnter, false);

			// 变更记录附件回写原单据
			CommonResponse<List<AttachmentVO>> response = attachmentApi.copyFiles(workerEnterRecord.getId().toString(), CHANGE_RECORD_BILL_TYPE, null, workerEnterEntity.getId().toString(), ENTER_BILL_TYPE, null, true);
			if (!response.isSuccess()) {
				throw new BusinessException(response.getMsg());
			}


			//删除变更记录及附件
			workerEnterRecordService.removeById(workerEnterRecord.getId(), false);
			CommonResponse<List<AttachmentVO>> response1 = attachmentApi.queryListBySourceId(workerEnterEntity.getId(),null,null,null);
			if (!response1.isSuccess()) {
				throw new BusinessException(response1.getMsg());
			}
			List<Long> fileIds = response1.getData().stream().map(AttachmentVO::getId).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(fileIds)) {
				// ,分隔fileIds
				String ids = fileIds.stream().map(String::valueOf).collect(Collectors.joining(","));
				CommonResponse<String> commonResponse = attachmentApi.delete(ids);
				if (!commonResponse.isSuccess()) {
					throw new BusinessException(commonResponse.getMsg());
				}
			}

		}*/
		return CommonResponse.error("弃审后不支持撤回！");
	}

}
