package com.ejianc.business.other.dangong.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.*;
import com.ejianc.business.other.enums.ConTypeEnum;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: jiang
 * @Date: 2025/8/7 17:57
 **/
@Controller
@RequestMapping("danGongPerson")
public class DanGongPersonController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DanGongPersonApiService danGongPersonApiService;

    @Autowired
    private IEquipRecordsService equipRecordsService;

    @Autowired
    private IAttendanceLogService attendanceLogService;

    @Autowired
    private IHengErEquipService hengErEquipService;

    /**
     * init初始化配置请求
     * @return
     */
    @RequestMapping(value = "/init", method = RequestMethod.GET)
    @ResponseBody
    public String init(@RequestParam("deviceId") String deviceId,
                                      @RequestParam("productId") String productId,
                                      @RequestParam("mac") String mac,
                                      @RequestParam("porttype") String porttype) {
        logger.info("弹弓初始化配置");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dgBaseInfo",new JSONObject());
        jsonObject.put("setting",new JSONObject());
        logger.info("弹弓初始化配置返回结果{}",JSONObject.toJSONString(DanGongResultUtils.success("init",jsonObject)));
        return JSONObject.toJSONString(DanGongResultUtils.success("init",jsonObject));
    }


    /**
     * 下载白名单
     * @return 返回JSON格式的人员信息
     */
    @RequestMapping(value = "/workers", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    @ResponseBody
    public String workers(@RequestParam("deviceId") String deviceId,
                          @RequestParam("productId") String productId,
                          @RequestParam(value = "update", required = false) String update) {

        logger.info("弹弓获取人员信息开始, deviceId: {}, productId: {}, update: {}", deviceId, productId, update);

        try {
            List<DanGongPersonVO> workerList = danGongPersonApiService.getWorkerList(deviceId, productId, update);
            String result = JSON.toJSONString(DanGongResultUtils.success("workers", workerList),
                    SerializerFeature.DisableCircularReferenceDetect,
                    SerializerFeature.WriteMapNullValue,
                    SerializerFeature.WriteDateUseDateFormat);

            logger.info("弹弓获取人员信息结果: {}", result);
            return result;
        } catch (Exception e) {
            logger.error("获取人员信息异常: ", e);
            return JSON.toJSONString(DanGongResultUtils.fail(-1,"获取人员信息失败"));
        }
    }

    /**
     * 考勤照片上传
     * @return
     */
    @RequestMapping(value = "/photo", method = RequestMethod.POST)
    @ResponseBody
    public DanGongPublicResultVO photo(@RequestBody DanGongPersonAttendanceVO body) {
        logger.info("弹弓获取考勤数据开始");
        logger.info("弹弓获取考勤信息结果{}",JSONObject.toJSONString(body));


        //毫秒时间戳
        String time = body.getTime();
        DateTime serviceDate = DateUtil.date(Long.parseLong(time));
        String deviceId = body.getDeviceId();
        Long workerId = Long.parseLong(body.getWorkerId());

        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(deviceId);
        equipRecordsEntity.setWorkerId(workerId);
//        equipRecordsEntity.setWorkerName(name);
        equipRecordsEntity.setServiceDate(serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.恒尔弹弓.getStatus());
//        equipRecordsEntity.setRecordType(tempValId);
        equipRecordsService.saveOrUpdate(equipRecordsEntity);

        HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(deviceId);
        if (hengErEquipVO == null) {
            throw new BusinessException("设备为空！");
        }
        String punchCardType = "1".equals(hengErEquipVO.getEnterType()) ? "上班打卡" : "下班打卡";
        attendanceLogService.synPunchCard(workerId, hengErEquipVO.getProjectId(), punchCardType, serviceDate);
        logger.info("弹弓获取考勤数据结束");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("path","");
        return DanGongResultUtils.success("photo",jsonObject);
    }

    /**
     * 照片质量反馈
     * @return
     */
    @RequestMapping(value = "/quality", method = RequestMethod.POST)
    @ResponseBody
    public DanGongPublicResultVO quality(@RequestBody DanGongPhotoQualityCheckVO body) {
        logger.info("弹弓获取照片质量反馈开始");
        logger.info("弹弓获取照片质量反馈结果{}",JSONObject.toJSONString(body));

        List<DanGongQualityDataVO> data = body.getData();
        if(ListUtil.isNotEmpty(data)){
            for (DanGongQualityDataVO datum : data) {
                if(!Objects.equals(datum.getCode(), "0")){
                    logger.info("保存错误信息到本地");
                    //保存失败信息
                }
            }
        }
        logger.info("弹弓获取照片质量反馈结束");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("workerId","");
        return DanGongResultUtils.success("quality",jsonObject);
    }
}
