package com.ejianc.business.other.dangong.service.api;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.DanGongPersonAttendanceVO;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.enums.ConTypeEnum;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;

import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.Calendar.HOUR_OF_DAY;


@Service("DanGongPersonApiService")
public class DanGongPersonApiServiceImpl implements DanGongPersonApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IEquipRecordsService equipRecordsService;
    @Autowired
    private IAttendanceLogService attendanceLogService;

    @Override
    public List<DanGongPersonVO> getWorkerList(String deviceId, String productId, String update) {
        HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(deviceId);
        Long projectId = hengErEquipVO.getProjectId();


        HengErEquipEntity entity = BeanMapper.map(hengErEquipVO, HengErEquipEntity.class);
        if (entity != null ) {
            if(entity.getEquipDate() != null){
                // 计算当前时间与设备最后同步时间的间隔（小时）
                long hoursBetween = DateUtil.between(entity.getEquipDate(), new Date(), DateUnit.HOUR);
                // 如果超过1小时才进行回写，避免频繁写入
                if (hoursBetween > 1) {
                    // 设备状态回写
                    entity.setEquipStatus("在线");
                    entity.setEquipDate(new Date()); // 更新同步时间为当前时间
                    hengErEquipService.saveOrUpdate(entity);

                    logger.info("设备{}状态已更新，距离上次更新间隔{}小时", entity.getEquipSn(), hoursBetween);
                }
            } else {
                // 设备状态回写
                entity.setEquipStatus("在线");
                entity.setEquipDate(new Date()); // 更新同步时间为当前时间
                hengErEquipService.saveOrUpdate(entity);
                logger.info("设备{}状态已初始化更新", entity.getEquipSn());
            }

        }

        List<DanGongPersonVO> danGongPersonVOS = new ArrayList<>();
        if("0".equals(update) || StringUtils.isEmpty(update)){
            //全量同步
            logger.info("全量同步开始1-------------");
            List<WorkRecordEntity> list = workRecordService.list(Wrappers.<WorkRecordEntity>lambdaQuery()
                    .eq(WorkRecordEntity::getProjectId, projectId)
            );
            if(ListUtil.isNotEmpty(list)) {

                for (WorkRecordEntity workRecordEntity : list) {
                    Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> fileData = listCommonResponse.getData();
                        if (ListUtil.isEmpty(fileData)) {
                            logger.info("无图片信息！");
                        }
                        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                                .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    } else {
                        throw new BusinessException("访问文件服务异常!");
                    }
                    DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
                    danGongPersonVO.setName(workRecordEntity.getName());
                    danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
                    String url = "https://pms.zzyjjt.com/" + fileIdRef.get(workRecordEntity.getId()).getFilePath();
                    danGongPersonVO.setPhoto(url);
                    if (workRecordEntity.getEnterExitState().equals(0)) {
                        danGongPersonVO.setDel("1");
                    } else {
                        danGongPersonVO.setDel("0");
                    }
                    danGongPersonVO.setIdCardNumber(workRecordEntity.getIdCard());

                    Date updateTime = new Date();
                    if (workRecordEntity.getUpdateTime() != null) {
                        updateTime = workRecordEntity.getUpdateTime();
                    } else if (workRecordEntity.getCreateTime() != null) {
                        updateTime = workRecordEntity.getCreateTime();
                    }
                    long time = updateTime.getTime() / 1000;
                    danGongPersonVO.setUpdate(String.valueOf(time));
                    danGongPersonVOS.add(danGongPersonVO);
                }
            }
        } else {
            logger.info("增量同步开始2-------------");
            //增量同步
            DateTime date = DateUtil.date(Long.parseLong(update)*1000).offset(DateField.of(HOUR_OF_DAY),-24);
            List<WorkRecordEntity> list = workRecordService.list(Wrappers.<WorkRecordEntity>lambdaQuery()
                    .eq(WorkRecordEntity::getProjectId, projectId)
                    .ge(WorkRecordEntity::getCreateTime, date)
            );
            if(ListUtil.isNotEmpty(list)){

                for (WorkRecordEntity workRecordEntity : list) {
                    Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
                    CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
                    if (listCommonResponse.isSuccess()) {
                        List<AttachmentVO> fileData = listCommonResponse.getData();
                        if (ListUtil.isEmpty(fileData)) {
                            logger.info("无图片信息！");
                        }
                        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                                .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    } else {
                        throw new BusinessException("访问文件服务异常!");
                    }
                    DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
                    danGongPersonVO.setName(workRecordEntity.getName());
                    danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
                    String url = "https://pms.zzyjjt.com/" + fileIdRef.get(workRecordEntity.getId()).getFilePath();
                    danGongPersonVO.setPhoto(url);
                    if(workRecordEntity.getEnterExitState().equals(0)){
                        danGongPersonVO.setDel("1");
                    } else {
                        danGongPersonVO.setDel("0");
                    }
                    danGongPersonVO.setIdCardNumber(workRecordEntity.getIdCard());

                    Date updateTime = new Date();
                    if(workRecordEntity.getUpdateTime() != null){
                        updateTime = workRecordEntity.getUpdateTime();
                    } else if(workRecordEntity.getCreateTime() != null){
                        updateTime = workRecordEntity.getCreateTime();
                    }
                    long time = updateTime.getTime()/1000;
                    danGongPersonVO.setUpdate(String.valueOf(time));
                    danGongPersonVOS.add(danGongPersonVO);
                }
            }

        }
        return danGongPersonVOS;
    }

    @Override
    public JSONObject getPhoto(DanGongPersonAttendanceVO vo) {

        //毫秒时间戳
        String time = vo.getTime();
        DateTime serviceDate = DateUtil.date(Long.parseLong(time));
        String deviceId = vo.getDeviceId();
        Long workerId = Long.parseLong(vo.getWorkerId());

        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(deviceId);
        equipRecordsEntity.setWorkerId(workerId);
//        equipRecordsEntity.setWorkerName(name);
        equipRecordsEntity.setServiceDate(serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.恒尔弹弓.getStatus());
//        equipRecordsEntity.setRecordType(tempValId);
        equipRecordsService.saveOrUpdate(equipRecordsEntity);

        HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(deviceId);
        if (hengErEquipVO == null) {
            throw new BusinessException("设备为空！");
        }
        String punchCardType = "1".equals(hengErEquipVO.getEnterType()) ? "上班打卡" : "下班打卡";
        attendanceLogService.synPunchCard(workerId, hengErEquipVO.getProjectId(), punchCardType, serviceDate);


        WorkRecordEntity workRecordEntity = workRecordService.selectById(workerId);
        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if (ListUtil.isEmpty(fileData)) {
                logger.info("无图片信息！");
            }
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        } else {
            throw new BusinessException("访问文件服务异常!");
        }
        DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
        danGongPersonVO.setName(workRecordEntity.getName());
        danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
        String url = "https://pms.zzyjjt.com/" + fileIdRef.get(workRecordEntity.getId()).getFilePath();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("path","");
        return jsonObject;
    }
}
