package com.ejianc.business.labor.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.vo.WorkerVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.labor.bean.WorkerEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公司花名册人员
 *
 * @author generator
 *
 */
@Mapper
public interface WorkerMapper extends BaseCrudMapper<WorkerEntity> {

    /**
     * @description: 查询班组下的人员
     *
     * @param page
     * @param wrapper
     * @param teamId
     * @return {@link List< WorkerEntity>}
     * @author songlx
     * @date: 2022/11/25
     */
    List<WorkerEntity> queryOrgTeamWorkerPage(Page<WorkerEntity> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param("teamId") Long teamId);

    /**
     * @description: 根据班组id改变劳务员工所属班组名称
     * 班组档案修改名称时，劳务员工冗余的所属班组名称没有变化
     * @param teamId 更新此班组下的所有劳务员工的teamname，适用班组名字更新
     * @param workerId 更新此劳务工人的teamname， 需要前置步骤把teamid放对先更新了
     * @return
     * @author songlx
     * @date: 2022/11/28
     */
    Integer updateWorkerTeamNameByTeamIdOrWorkerId(@Param("teamId") Long teamId, @Param("workerId") Long workerId);
}
