package com.ejianc.business.other.xiaoshi.controller;

import com.ejianc.business.base.vo.BaseTeamVO;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiEquipApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPersonApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: jiang
 * @Date: 2023/12/13 16:42
 **/


@Controller
@RequestMapping("/xiaoShiApi/person")
public class XiaoShiPersonApiController {


    @Autowired
    private XiaoShiPersonApiService personApiService;

    @Autowired
    private IWorkerService workerService;


    @RequestMapping(value = "/synPerson", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> synPerson() {
        personApiService.synPerson();
        return CommonResponse.success("调用同步接口成功！");
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody

    public CommonResponse<String> delete(@RequestBody List<WorkRecordVO> vos) {

        List<Long> workIds = vos.stream().map(WorkRecordVO::getId).collect(Collectors.toList());
        personApiService.delete(workIds);
        return CommonResponse.success("删除成功！");
    }
}
