package com.ejianc.business.other.controller.warn;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 预警
 *
 * @Author: jiang
 * @Date: 2025/9/18 7:49
 **/
@Controller
@RequestMapping("warn")
public class WarnController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IPorjectService porjectService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * @Description equipStateWarn 设备状态预警
     * @Param [ids]
     */
    @RequestMapping(value = "equipStateWarn",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> equipStateWarn(HttpServletRequest request){
        logger.info("设备状态预警开始---------");
        // 获取当前时间
        Date now = DateUtil.date();

        // 计算四小时前的时间点
        Date fourHoursAgo = DateUtil.offsetHour(now, -4);

//        porjectService.list(Wrappers.<PorjectEntity>lambdaQuery().eq(PorjectEntity::getConType,))
        List<HengErEquipEntity> list = hengErEquipService.list(Wrappers.<HengErEquipEntity>lambdaQuery()
                .in(HengErEquipEntity::getBillState, Arrays.asList(1, 3))
                .eq(HengErEquipEntity::getEquipDate, fourHoursAgo)
        );
        if(ListUtil.isNotEmpty(list)){
            List<Long> projectIds = list.stream().map(HengErEquipEntity::getProjectId).collect(Collectors.toList());
            Collection<PorjectEntity> projectList = porjectService.listByIds(projectIds);
            if(CollectionUtil.isNotEmpty(projectList)){
                for (PorjectEntity porjectEntity : projectList) {
                    List<HengErEquipEntity> sendList = new ArrayList<>();
                    for (HengErEquipEntity hengErEquipEntity : list) {
                        if(porjectEntity.getId().equals(hengErEquipEntity.getProjectId())){
                            sendList.add(hengErEquipEntity);
                        }
                    }
                    this.sendMsg(sendList,porjectEntity.getWarnPerson());
                }
            }
        }
        return CommonResponse.success("修改已归档状态成功！");
    }

    @Value("${msg.anentId}")
    private String anentId;
    @Value("${msg.secret}")
    private String secret;
    @Value("${msg.enUrl}")
    private String enUrl;

    public boolean sendMsg(List<HengErEquipEntity> list,String idString) {

        /**
         *  预警人员列表
         */
        List<String> userIds = StrUtil.split(idString, ',');
        /**
         * 推送内容：
         * 合同名称：
         * 确认报审金额：（如有多个单据报审金额为累计金额）。
         */
        String subject = "【实名制人脸设备预警】";
        String content = "项目名称:【" + list.get(0).getProjectName() + "】";
        String detail = "\n共" + list.size() + "台设备已超过4小时未在线,请及时进行确认!";
        String pcUrl = "/ejc-zzyjlabor-frontend/#/hengErEquip";

        /**
         * 发送消息
         */
        for (String userId : userIds) {

//            String moUrl = enUrl+"/portal/sso/index?&userid="+userId+
//                    "&targeturl="+enUrl+"/ejc-proincome-frontend/#/finalized/card?id="+vos.get(0).getId();
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);//
            String[] receivers = {userId};
            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");//预警消息
            parameter.setSubject(content+detail);// 标题
            parameter.setContent(content+detail);// 内容
            parameter.setPcUrl(pcUrl);// pc端url
            parameter.setMobileUrl(pcUrl);// 移动端url
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", anentId);//企业微信应用id
            weixineeParams.put("secret", secret);//企业微信secret
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", subject);
            weixineeParams.put("description", content);
            weixineeParams.put("url", (enUrl+"/portal/sso/index?&userid="+userId+
                    "&targeturl="+enUrl+"/ejc-zzyjlabor-frontend/#/hengErEquip"));//移动端点击的urlweixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);

            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        }
        return true;

    }

}
