/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.enums.ConTypeEnum;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiLogEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiLogService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service(value="XiaoShiPublicApiService")
public class XiaoShiPublicApiServiceImpl
implements XiaoShiPublicApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IXiaoShiEquipService equipService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IXiaoShiLogService xiaoShiLogService;
    private static String appKey = "94988e1a478141959da73bce47ecf82c";
    private static String appSecret = "c57ef88f400f4bb7ac91ed5ccd937c24";
    private static String baseUrl = "https://am-api.minivision.cn/openApi";

    @Override
    public JSONObject getAuthorToken() {
        Long timestamp = System.currentTimeMillis();
        JSONObject redisToken = (JSONObject)this.cacheManager.get("xiaoshi::authorToken::" + appKey);
        if (redisToken != null) {
            return redisToken;
        }
        String signature = "";
        try {
            signature = DigestUtils.md5DigestAsHex((byte[])(appKey + appSecret + timestamp).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JSONObject queryParam = new JSONObject();
        queryParam.put("appKey", (Object)appKey);
        queryParam.put("timestamp", (Object)timestamp);
        queryParam.put("signature", (Object)signature);
        this.logger.info("\u83b7\u53d6AuthorToken\u53d1\u9001\u53c2\u6570{}", (Object)queryParam.toJSONString());
        JSONObject resData = this.sendPostRequestNoAuth("/adm/common/v1/token", queryParam);
        this.logger.info("\u63a5\u6536AuthorToken\u7ed3\u679c\u4e3a{}", (Object)resData.toJSONString());
        String token = resData.getString("token");
        JSONObject authorToken = new JSONObject();
        authorToken.put("token", (Object)token);
        authorToken.put("appKey", (Object)appKey);
        this.cacheManager.setex("xiaoshi::authorToken::" + appKey, (Serializable)authorToken, 3600);
        return authorToken;
    }

    @Override
    public JSONObject sendPostRequestNoAuth(String queryUrl, JSONObject queryParam) {
        try {
            this.logger.info("\u83b7\u53d6token\u53c2\u6570\u4e3a" + queryParam.toJSONString());
            URL url = new URL(baseUrl + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                this.logger.info("\u8c03\u7528token\u67e5\u8be2\u7ed3\u679c\u4e3a{}", (Object)response.toString());
                return this.handelResJSON(JSONObject.parseObject((String)response.toString()), queryUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public JSONObject sendPostRequest(String queryUrl, JSONObject queryParam) {
        try {
            this.logger.info("\u67e5\u8be2\u4e1a\u52a1api\u4e3a" + queryUrl);
            this.logger.info("\u67e5\u8be2\u4e1a\u52a1\u53c2\u6570\u4e3a" + queryParam.toJSONString());
            URL url = new URL(baseUrl + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            JSONObject authorToken = this.getAuthorToken();
            connection.setRequestProperty("appKey", authorToken.get((Object)"appKey").toString());
            connection.setRequestProperty("token", authorToken.get((Object)"token").toString());
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                this.logger.info("\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c\u4e3a{}", (Object)response.toString());
                XiaoShiLogEntity xiaoShiLogEntity = new XiaoShiLogEntity();
                xiaoShiLogEntity.setInputParams(queryParam.toString());
                xiaoShiLogEntity.setInterfaceName(queryUrl);
                xiaoShiLogEntity.setResData(response.toString());
                xiaoShiLogEntity.setLogType(ConTypeEnum.\u5c0f\u89c6.getStatus());
                JSONObject baseResJSON = JSONObject.parseObject((String)response.toString());
                if (baseResJSON != null) {
                    String resCode = baseResJSON.getString("resCode");
                    String resMsg = baseResJSON.getString("resMsg");
                    xiaoShiLogEntity.setResCode(resCode);
                    xiaoShiLogEntity.setResMsg(resMsg);
                }
                this.xiaoShiLogService.saveOrUpdate((Object)xiaoShiLogEntity);
                return this.handelResJSON(baseResJSON, queryUrl);
            }
            this.logger.info("\u670d\u52a1\u5668\u672a\u54cd\u5e94" + responseCode);
            throw new BusinessException(Integer.valueOf(responseCode));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject handelResJSON(JSONObject resJSON, String queryUrl) {
        this.logger.info("\u5904\u7406\u67e5\u8be2\u7ed3\u679c");
        if (resJSON == null) {
            throw new BusinessException("\u5c0f\u89c6\u79d1\u6280\u7f51\u7edc\u5f02\u5e38\uff0c\u65e0\u6cd5\u5efa\u7acb\u8fde\u63a5\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        String resCode = resJSON.getString("resCode");
        JSONArray resMsg = resJSON.getJSONArray("resMsg");
        JSONObject resData = new JSONObject();
        String[] urlSplit = queryUrl.split("/");
        if (urlSplit[urlSplit.length - 1].equals("add")) {
            String resDataString = resJSON.getString("resData");
            if (!resDataString.contains("Id")) {
                urlSplit[2] = urlSplit[2] + "Id";
                resData.put(urlSplit[2], (Object)resDataString);
            } else {
                resData = resJSON.getJSONObject("resData");
            }
        } else {
            resData = resJSON.getJSONObject("resData");
        }
        this.logger.info("\u8f6c\u6362\u540eresData\u6570\u636e\u4e3a" + resData.toString());
        if (!"1".equals(resCode)) {
            throw new BusinessException("\u9519\u8bef\u4ee3\u7801\uff1a[" + resMsg.getString(0) + "]");
        }
        return resData;
    }
}

