package com.ejianc.business.labor.service.impl;

import com.ejianc.business.labor.bean.PersonContractEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IPersonContractService;
import com.ejianc.business.labor.service.IWorkRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("personContract") 
public class PersonContractBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPersonContractService personContractService;

	@Autowired
	private IWorkRecordService workRecordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		/**
		 * 回填合同信息到用工记录里
		 */
		PersonContractEntity personContractEntity = personContractService.selectById(billId);
		if(personContractEntity.getWorkerId() != null){
			logger.info("1----------------合同信息推送用工记录开始");
			WorkRecordEntity workRecordEntity = workRecordService.selectById(personContractEntity.getWorkerId());
			if(workRecordEntity != null){
				workRecordEntity.setPersonContract(personContractEntity.getId());
				workRecordEntity.setPersonContractName(personContractEntity.getContractName());
				workRecordEntity.setWage(personContractEntity.getWage());
				workRecordEntity.setWagesType(personContractEntity.getWagesType());
				workRecordEntity.setWagesTypeName(personContractEntity.getWagesTypeName());
				workRecordEntity.setOvertimeWage(personContractEntity.getOvertimeWage());
				workRecordService.saveOrUpdate(workRecordEntity);
				logger.info("2----------------合同信息推送用工记录结束");
				return CommonResponse.success();
			}
		}

		return CommonResponse.error("数据异常，请联系管理员!");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
