package com.ejianc.business.other.yufan.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.xiaoshi.service.XiaoShiRecordsApiService;
import com.ejianc.business.other.yufan.service.YuFanEquipApiService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * @Author: jiang
 * @Date: 2023/12/13 16:42
 **/


@Controller
@RequestMapping("/yuFanApi/records")
public class YuFanRecordsApiController {

    @Autowired
    private YuFanEquipApiService yuFanEquipApiService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value = "/callBackEquipRecordData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> callBackEquipRecordData(
            @RequestParam("eventGuid") String eventGuid,
            @RequestParam("eventCode") String eventCode,
            @RequestParam("eventMsg") String eventMsg
    ) {
        logger.info("宇泛认证结果接受成功-------------------");
        logger.info("-------------------eventGuid{}", eventGuid);
        logger.info("-------------------eventCode{}", eventCode);
        logger.info("-------------------eventMsg{}", eventMsg);
        yuFanEquipApiService.callBackEquipRecordData(JSONObject.parseObject(eventMsg));
        return CommonResponse.success("调用宇泛识别回调接口成功！");
    }
}
