package com.ejianc.business.other.henger.service.api;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorkerExitDetailEntity;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.enums.PersonTypeEnum;
import com.ejianc.business.other.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.HengErPersonApiService;

import com.ejianc.business.other.henger.service.HengErPublicApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.*;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 恒尔接口公用api
 *
 * @author generator
 */
@Service("HengErPersonApiService")
public class HengErPersonApiServiceImpl implements HengErPersonApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private HengErPublicApiService hengErPublicApiService;

    @Override
    public void add(WorkRecordVO vo) {


        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if (ListUtil.isEmpty(fileData)) {
                logger.info("无图片信息！");
            }
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        } else {
            throw new BusinessException("访问文件服务异常!");
        }
        /**
         * 1.1获取图片唯一标识
         */
        AttachmentVO attachmentVO = fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        //图片类型：1-jpg，2-png
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        Long fileId = fileIdRef.get(vo.getId()).getId();
        String image = "";
        /**
         * 1.2获取服务器中图片,并转化为base64
         */
        Response response = attachmentApi.downloadFileById(fileId);
        try {
            /**
             * 转化为base64编码
             */
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray(inputStream);
            image = Base64.getEncoder().encodeToString(bytes);

        } catch (IOException e) {
            e.printStackTrace();
        }

        String apiUrl = "AddPerson";
        String ip = "172.16.105.14";
        String sn = "2369912";
        /**
         * 1.3人员基本信息
         */
        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        queryParam.put("operator", apiUrl);

        infoDetail.put("DeviceID", sn);
        infoDetail.put("PersonUUID", vo.getWorkerId());
//        infoDetail.put("PersonType", 0);
        infoDetail.put("Name", vo.getName());
        if (vo.getSex() != null) {
            //1-男 2-女 转化为第三方 0-男 1-女
            infoDetail.put("Gender", vo.getSex() == 1 ? 0 : 1);
        }
        infoDetail.put("CardType", 0);
        infoDetail.put("IdCard", vo.getIdCardNo());
        infoDetail.put("Telnum", vo.getPhone());


        queryParam.put("info", infoDetail);
//        queryParam.put("picinfo", image);
        String url = "https://pms.zzyjjt.com/" + fileIdRef.get(vo.getId()).getFilePath();
        queryParam.put("picURI", url);
        JSONObject jsonObject = hengErPublicApiService.sendPostRequest(ip, apiUrl, queryParam);

    }

    @Override
    public JSONObject getAddCom(WorkRecordVO vo, String equipSn) {
        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if (ListUtil.isEmpty(fileData)) {
                logger.info("无图片信息！");
            }
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        } else {
            throw new BusinessException("访问文件服务异常!");
        }
        /**
         * 1.1获取图片地址
         */
        AttachmentVO attachmentVO = fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        //图片类型：1-jpg，2-png
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        Long fileId = fileIdRef.get(vo.getId()).getId();
        String image = "";
        String url = "https://pms.zzyjjt.com/" + fileIdRef.get(vo.getId()).getFilePath();

        /**
         * 1.2获取服务器中图片,并转化为base64
         */
        Response response = attachmentApi.downloadFileById(fileId);
        try {
            /**
             * 转化为base64编码
             */
            InputStream inputStream = response.body().asInputStream();
            byte[] sourceBytes = IOUtils.toByteArray(inputStream);

//            byte[] bytes = resizeImage(url, 400, 700);
            byte[] bytes = resizeImage(sourceBytes, fileIdRef.get(vo.getId()).getFilePath(), 960, 1280);
            image = Base64.getEncoder().encodeToString(bytes);

        } catch (IOException e) {
            e.printStackTrace();
        }
        /**
         * 1.2人员基本信息
         */
        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        String apiUrl = "AddPerson";
        queryParam.put("operator", apiUrl);

        infoDetail.put("DeviceID", equipSn);
        infoDetail.put("PersonUUID", vo.getWorkerId());
//        infoDetail.put("PersonType", 0);
        infoDetail.put("Name", vo.getName());
        if(vo.getPersonType() != null && vo.getPersonType().equals(PersonTypeEnum.临时人员.getStatus())){
            Date date = new Date();

            DateTime startDate = DateUtil.beginOfDay(date);
            DateTime endDate = DateUtil.endOfDay(DateUtil.offsetDay(date,1));

            infoDetail.put("Tempvalid",7);
            infoDetail.put("ValidBegin",DateUtil.format(startDate, DatePattern.UTC_PATTERN));
            infoDetail.put("ValidEnd",DateUtil.format(endDate,DatePattern.UTC_PATTERN));
        }
        if (vo.getSex() != null) {
            //1-男 2-女 转化为第三方 0-男 1-女
            infoDetail.put("Gender", vo.getSex() == 1 ? 0 : 1);
        }
        infoDetail.put("CardType", 0);
        infoDetail.put("IdCard", vo.getIdCardNo());
        infoDetail.put("Telnum", vo.getPhone());

        queryParam.put("info", infoDetail);

//        queryParam.put("picURI", url);
        queryParam.put("picinfo", image);
        return queryParam;
    }

    @Override
    public JSONObject getDelCom(WorkerExitDetailEntity vo, String equipSn) {

        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        String apiUrl = "DeletePerson";
        queryParam.put("operator", apiUrl);
        infoDetail.put("DeviceID", equipSn);
        infoDetail.put("PersonUUID", vo.getWorkerId());
        infoDetail.put("IdType", 2);
        infoDetail.put("TotalNum", 1);
        infoDetail.put("CardType", 0);
        queryParam.put("info", infoDetail);

        return queryParam;
    }


    /**
     * 压缩图片
     *
     * @param inputPath
     * @param width
     * @param height
     * @return
     * @throws IOException
     */
    public static byte[] resizeImage(byte[] bytes,String inputPath, int width, int height) throws IOException {

        String subfix = "jpg";
        subfix = inputPath.substring(inputPath.lastIndexOf(".") + 1);

        InputStream buffIn = new ByteArrayInputStream(bytes);
        BufferedImage originalImage = ImageIO.read(buffIn);

        int scaledWidth = width;
        int scaledHeight = height;

        if (originalImage.getWidth() > originalImage.getHeight()) {
            scaledHeight = (int) (width * originalImage.getHeight() / (double) originalImage.getWidth());
        } else {
            scaledWidth = (int) (height * originalImage.getWidth() / (double) originalImage.getHeight());
        }

        Image scaledImage = originalImage.getScaledInstance(scaledWidth, scaledHeight, Image.SCALE_SMOOTH);
        BufferedImage outputImage = null;
        if (subfix.equals("png") || subfix.equals("PNG")) {
            outputImage = new BufferedImage(scaledWidth, scaledHeight, BufferedImage.TYPE_INT_ARGB);
        } else {
            outputImage = new BufferedImage(scaledWidth, scaledHeight, BufferedImage.TYPE_INT_RGB);
        }

        Graphics2D graphics2D = outputImage.createGraphics();
        graphics2D.drawImage(scaledImage, 0, 0, null);
        graphics2D.dispose();


        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(outputImage, subfix, baos);

//        String inputImagePath = "input." + subfix;
//        String outputImagePath = "output." + subfix;
//
//
//        ImageIO.write(originalImage, subfix, new File(inputImagePath));
//        ImageIO.write(outputImage, subfix, new File(outputImagePath));
        return baos.toByteArray();

    }

    @Override
    public JSONObject getSearchPersonListCom(String equipSn,Integer beginNO) {

        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        String apiUrl = "SearchPersonList";
        queryParam.put("operator", apiUrl);
        infoDetail.put("DeviceID", equipSn);
        if(beginNO != null){
            infoDetail.put("BeginNO", beginNO);
        }
        infoDetail.put("Picture", "0");
        queryParam.put("info",infoDetail);

        return queryParam;
    }

    @Override
    public JSONObject getSearchPersonCom(String equipSn,Long workerId) {

        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        String apiUrl = ServiceTypeEnum.单个名单查询.getStatus();
        queryParam.put("operator", apiUrl);
        infoDetail.put("DeviceID", equipSn);
        infoDetail.put("SearchType", 1);
        infoDetail.put("SearchID", workerId.toString());
        infoDetail.put("Picture", "0");
        queryParam.put("info",infoDetail);

        return queryParam;
    }

}
