/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.henger.service.api;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorkerExitDetailEntity;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.enums.PersonTypeEnum;
import com.ejianc.business.other.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.HengErPersonApiService;
import com.ejianc.business.other.henger.service.HengErPublicApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="HengErPersonApiService")
public class HengErPersonApiServiceImpl
implements HengErPersonApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private HengErPublicApiService hengErPublicApiService;

    @Override
    public void add(WorkRecordVO vo) {
        List fileData;
        Map<Object, Object> fileIdRef = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            fileData = (List)listCommonResponse.getData();
            if (ListUtil.isEmpty((List)fileData)) {
                this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
            }
        } else {
            throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
        }
        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        AttachmentVO attachmentVO = (AttachmentVO)fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        Long fileId = ((AttachmentVO)fileIdRef.get(vo.getId())).getId();
        String image = "";
        Response response = this.attachmentApi.downloadFileById(fileId);
        try {
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            image = Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String apiUrl = "AddPerson";
        String ip = "172.16.105.14";
        String sn = "2369912";
        JSONObject queryParam = new JSONObject(new LinkedHashMap());
        JSONObject infoDetail = new JSONObject();
        queryParam.put("operator", (Object)apiUrl);
        infoDetail.put("DeviceID", (Object)sn);
        infoDetail.put("PersonUUID", (Object)vo.getWorkerId());
        infoDetail.put("Name", (Object)vo.getName());
        if (vo.getSex() != null) {
            infoDetail.put("Gender", (Object)(vo.getSex() == 1 ? 0 : 1));
        }
        infoDetail.put("CardType", (Object)0);
        infoDetail.put("IdCard", (Object)vo.getIdCardNo());
        infoDetail.put("Telnum", (Object)vo.getPhone());
        queryParam.put("info", (Object)infoDetail);
        String url = "https://pms.zzyjjt.com/" + ((AttachmentVO)fileIdRef.get(vo.getId())).getFilePath();
        queryParam.put("picURI", (Object)url);
        JSONObject jsonObject = this.hengErPublicApiService.sendPostRequest(ip, apiUrl, queryParam);
    }

    @Override
    public JSONObject getAddCom(WorkRecordVO vo, String equipSn) {
        List fileData;
        Map<Object, Object> fileIdRef = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            fileData = (List)listCommonResponse.getData();
            if (ListUtil.isEmpty((List)fileData)) {
                this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
            }
        } else {
            throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
        }
        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        AttachmentVO attachmentVO = (AttachmentVO)fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        Long fileId = ((AttachmentVO)fileIdRef.get(vo.getId())).getId();
        String image = "";
        String url = "https://pms.zzyjjt.com/" + ((AttachmentVO)fileIdRef.get(vo.getId())).getFilePath();
        Response response = this.attachmentApi.downloadFileById(fileId);
        try {
            InputStream inputStream = response.body().asInputStream();
            byte[] sourceBytes = IOUtils.toByteArray((InputStream)inputStream);
            byte[] bytes = HengErPersonApiServiceImpl.resizeImage(sourceBytes, ((AttachmentVO)fileIdRef.get(vo.getId())).getFilePath(), 960, 1280);
            image = Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject queryParam = new JSONObject(new LinkedHashMap());
        JSONObject infoDetail = new JSONObject();
        String apiUrl = "AddPerson";
        queryParam.put("operator", (Object)apiUrl);
        infoDetail.put("DeviceID", (Object)equipSn);
        infoDetail.put("PersonUUID", (Object)vo.getWorkerId());
        infoDetail.put("Name", (Object)vo.getName());
        if (vo.getPersonType() != null && vo.getPersonType().equals(PersonTypeEnum.\u4e34\u65f6\u4eba\u5458.getStatus())) {
            Date date = new Date();
            DateTime startDate = DateUtil.beginOfDay((Date)date);
            DateTime endDate = DateUtil.endOfDay((Date)DateUtil.offsetDay((Date)date, (int)1));
            infoDetail.put("Tempvalid", (Object)7);
            infoDetail.put("ValidBegin", (Object)DateUtil.format((Date)startDate, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
            infoDetail.put("ValidEnd", (Object)DateUtil.format((Date)endDate, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        }
        if (vo.getSex() != null) {
            infoDetail.put("Gender", (Object)(vo.getSex() == 1 ? 0 : 1));
        }
        infoDetail.put("CardType", (Object)0);
        infoDetail.put("IdCard", (Object)vo.getIdCardNo());
        infoDetail.put("Telnum", (Object)vo.getPhone());
        queryParam.put("info", (Object)infoDetail);
        queryParam.put("picinfo", (Object)image);
        return queryParam;
    }

    @Override
    public JSONObject getDelCom(WorkerExitDetailEntity vo, String equipSn) {
        JSONObject queryParam = new JSONObject(new LinkedHashMap());
        JSONObject infoDetail = new JSONObject();
        String apiUrl = "DeletePerson";
        queryParam.put("operator", (Object)apiUrl);
        infoDetail.put("DeviceID", (Object)equipSn);
        infoDetail.put("PersonUUID", (Object)vo.getWorkerId());
        infoDetail.put("IdType", (Object)2);
        infoDetail.put("TotalNum", (Object)1);
        infoDetail.put("CardType", (Object)0);
        queryParam.put("info", (Object)infoDetail);
        return queryParam;
    }

    public static byte[] resizeImage(byte[] bytes, String inputPath, int width, int height) throws IOException {
        String subfix = "jpg";
        subfix = inputPath.substring(inputPath.lastIndexOf(".") + 1);
        ByteArrayInputStream buffIn = new ByteArrayInputStream(bytes);
        BufferedImage originalImage = ImageIO.read(buffIn);
        int scaledWidth = width;
        int scaledHeight = height;
        if (originalImage.getWidth() > originalImage.getHeight()) {
            scaledHeight = (int)((double)(width * originalImage.getHeight()) / (double)originalImage.getWidth());
        } else {
            scaledWidth = (int)((double)(height * originalImage.getWidth()) / (double)originalImage.getHeight());
        }
        Image scaledImage = originalImage.getScaledInstance(scaledWidth, scaledHeight, 4);
        BufferedImage outputImage = null;
        outputImage = subfix.equals("png") || subfix.equals("PNG") ? new BufferedImage(scaledWidth, scaledHeight, 2) : new BufferedImage(scaledWidth, scaledHeight, 1);
        Graphics2D graphics2D = outputImage.createGraphics();
        graphics2D.drawImage(scaledImage, 0, 0, null);
        graphics2D.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)outputImage, subfix, baos);
        return baos.toByteArray();
    }

    @Override
    public JSONObject getSearchPersonListCom(String equipSn, Integer beginNO) {
        JSONObject queryParam = new JSONObject(new LinkedHashMap());
        JSONObject infoDetail = new JSONObject();
        String apiUrl = "SearchPersonList";
        queryParam.put("operator", (Object)apiUrl);
        infoDetail.put("DeviceID", (Object)equipSn);
        if (beginNO != null) {
            infoDetail.put("BeginNO", (Object)beginNO);
        }
        infoDetail.put("Picture", (Object)"0");
        queryParam.put("info", (Object)infoDetail);
        return queryParam;
    }

    @Override
    public JSONObject getSearchPersonCom(String equipSn, Long workerId) {
        JSONObject queryParam = new JSONObject(new LinkedHashMap());
        JSONObject infoDetail = new JSONObject();
        String apiUrl = ServiceTypeEnum.\u5355\u4e2a\u540d\u5355\u67e5\u8be2.getStatus();
        queryParam.put("operator", (Object)apiUrl);
        infoDetail.put("DeviceID", (Object)equipSn);
        infoDetail.put("SearchType", (Object)1);
        infoDetail.put("SearchID", (Object)workerId.toString());
        infoDetail.put("Picture", (Object)"0");
        queryParam.put("info", (Object)infoDetail);
        return queryParam;
    }
}

