package com.ejianc.business.other.yufan.service.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 宇泛接口公用api
 *
 * @author Jiang
 */
@Service("YuFanPublicApiService")
public class YuFanPublicApiServiceImpl implements YuFanPublicApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());



    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IPorjectService porjectService;

//    private static String appId = "E2FC9FF5570143A09FE00A9CEDC1ABA8";//projectGuid
//    private static String appKey = "243C7D03AEAE458F99A3259980A82487";
//    private static String appSecret = "18C22C7AFAEC4812A877A29C9B79388B";
    private static String baseUrl = "http://wo-api.uni-ubi.com/";
//    private static String appId = "A90A8BBDDAF64314B0C1C4F0E40990F5";//projectGuid
//    private static String appKey = "B035C69A5A214B8BA2F94F2A7F62EF90";
//    private static String appSecret = "A99E7E5DADFB4D528686050767F3B6BD";
    @Override
    public JSONObject getAuthorToken(String appId,String appKey,String appSecret) {


        JSONObject redisToken = cacheManager.get("YuFan::authorToken::" + appKey);

        /**
         * 获取AutohorToken必要参数，默认24小时有效期
         */
        String sign = "";
        Long timestamp = System.currentTimeMillis();
        if (redisToken != null) {
            logger.info("现存AuthorToken结果为{}", redisToken);
            return redisToken;
        } else {
            try {
                sign = org.springframework.util.DigestUtils.md5DigestAsHex((appKey + timestamp + appSecret ).getBytes("utf-8"));

            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            JSONObject queryParam = new JSONObject();
            queryParam.put("projectGuid", appId);
            logger.info("获取AuthorToken发送参数{}", queryParam.toJSONString());
            JSONObject resData = sendPostRequestNoAuth(appId,appKey,timestamp.toString(),sign,queryParam);
            logger.info("接收AuthorToken结果为{}", resData.toJSONString());


            String token = resData.getString("data");
            JSONObject authorToken = new JSONObject();
            authorToken.put("token", token);
            authorToken.put("projectGuid", appId);
            cacheManager.setex("YuFan::authorToken::" + appKey, authorToken, 60 * 60 * 24);
            return authorToken;
        }


    }


    /**
     * 发送请求方法获取token
     *
     * @return
     */

    public JSONObject sendPostRequestNoAuth(String appId,String appKey, String timestamp, String sign,JSONObject queryParam) {
        try {
//            logger.info("获取token参数为" + queryParam.toJSONString());

            String queryUrl = baseUrl+"/v1/"+appId+"/auth?projectGuid="+queryParam.getString("projectGuid");
            URL url = new URL(queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");


            // 在Header中添加参数
            connection.setRequestProperty("appKey", appKey);
            connection.setRequestProperty("timestamp", timestamp);
            connection.setRequestProperty("sign", sign);


            connection.setDoOutput(false);
//            // 将JSON字符串作为请求体发送
//            OutputStream outputStream = connection.getOutputStream();
//            outputStream.write(queryParam.toString().getBytes());
//
//            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("调用token查询结果为{}", response.toString());
                return handelResJSON(JSONObject.parseObject(response.toString()),"authToken");
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 业务通用发送请求方法
     *
     * @param queryUrl   查询接口地址
     * @param queryParam 查询参数
     * @return
     */
    @Override
    public JSONObject sendPostRequest(String queryUrl, JSONObject queryParam,Long projectId) {
        try {
            logger.info("查询业务api为" + queryUrl);
            logger.info("查询业务参数为" + queryParam.toJSONString());


            PorjectEntity porjectEntity = porjectService.selectById(projectId);
            String appId = porjectEntity.getAppId();
            String appKey = porjectEntity.getAppKey();
            String appSecret = porjectEntity.getAppSecret();


            URL url = new URL(baseUrl + queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            JSONObject authorToken = getAuthorToken(appId,appKey,appSecret);
            /**
             * header中添加必要的token信息
             */
            connection.setRequestProperty("projectGuid", appId);
            connection.setRequestProperty("token", authorToken.get("token").toString());
            // 在Header中添加参数
//            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            if(queryParam != null){
                outputStream.write(queryParam.toString().getBytes());
            }

            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("调用接口查询结果为{}", response.toString());


                /**
                 * 每次请求保存日志
                 */
//                XiaoShiLogEntity xiaoShiLogEntity = new XiaoShiLogEntity();
//                xiaoShiLogEntity.setInputParams(queryParam.toString());
//                xiaoShiLogEntity.setInterfaceName(queryUrl);
//                xiaoShiLogEntity.setResData(response.toString());
//                xiaoShiLogEntity.setLogType(ConTypeEnum.宇泛.getStatus());
                JSONObject baseResJSON = JSONObject.parseObject(response.toString());
//                if(baseResJSON != null){
//                    String resCode = baseResJSON.getString("code");
//                    String resMsg = baseResJSON.getString("msg");
//                    xiaoShiLogEntity.setResCode(resCode);
//                    xiaoShiLogEntity.setResMsg(resMsg);
//                }
//                xiaoShiLogService.saveOrUpdate(xiaoShiLogEntity);

                return handelResJSON(baseResJSON,queryUrl);
            }
            logger.info("服务器未响应"+responseCode);
            throw new BusinessException(responseCode);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 处理返回结果
     *
     * @param resJSON
     * @return
     */
    private JSONObject handelResJSON(JSONObject resJSON,String queryUrl) {
        logger.info("处理查询结果");
        if (resJSON == null) {
            throw new BusinessException("宇泛平台网络异常，无法建立连接，请稍后再试！");
        }


        String resCode = resJSON.getString("code");
        String resMsg = resJSON.getString("msg");
        if (!"WO_SUS1000".equals(resCode)) {
            throw new BusinessException("错误代码：[" + resMsg + "]");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data",resJSON.get("data"));
        return jsonObject;
//        /**
//         * 由于返回数据不统一，对token方法进行特殊处理
//         */
//        if("authToken".equals(queryUrl)){
//
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("token",resJSON.getString("data"));
//
//            return jsonObject;
//
//        } else if("/v2/admit/delete".equals(queryUrl)){
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("data",resJSON.get("data"));
//            return jsonObject;
//        } else{
//            JSONObject resData = new JSONObject();
//            if(resJSON.get("data") != null){
//                resData = resJSON.getJSONObject("data");
//                logger.info("转换后resData数据为"+resData.toString());
//                return resData;
//            } else {
//                return null;
//            }
//
//        }



    }
}
