/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.mapper.SalaryMapper;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.business.labor.vo.importSalaryDetailVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="salaryService")
public class SalaryServiceImpl
extends BaseServiceImpl<SalaryMapper, SalaryEntity>
implements ISalaryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectTeamService projectTeamService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long projectId = Long.parseLong(request.getParameter("sourceId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<importSalaryDetailVO> successList = new ArrayList<importSalaryDetailVO>();
        ArrayList<importSalaryDetailVO> errorList = new ArrayList<importSalaryDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 16) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            HashMap<String, Integer> idCardMap = new HashMap<String, Integer>();
            StringBuilder errMsg = new StringBuilder();
            for (int i = 1; i < result.size(); ++i) {
                List list;
                int rowNum = i + 2;
                List datas = (List)result.get(i);
                importSalaryDetailVO salaryDetailVO = new importSalaryDetailVO();
                if (StringUtils.isBlank((String)((String)datas.get(0)))) {
                    errMsg.append("`\u540d\u5b57\u4e3a\u5fc5\u586b\u9879`");
                }
                salaryDetailVO.setWorkerName((String)datas.get(0));
                if (((String)datas.get(1)).length() == 0) {
                    errMsg.append("`\u8eab\u4efd\u8bc1\u4e3a\u5fc5\u586b\u9879`");
                }
                if (datas.get(1) != null && StringUtils.isNotBlank((String)((String)datas.get(1)))) {
                    String idCard = ((String)datas.get(1)).trim();
                    if (!idCardMap.containsKey(idCard)) {
                        if (!idCard.matches(IdCardRegex)) {
                            errMsg.append("`\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef`");
                        }
                        idCardMap.put(idCard, rowNum);
                        salaryDetailVO.setIdCard(idCard);
                    } else {
                        errMsg.append("`\u7b2c" + idCardMap.get(idCard) + "\u3001" + rowNum + "\u884c\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d`");
                    }
                }
                if (datas.get(2) != null) {
                    if ("\u7537".equals(datas.get(2))) {
                        salaryDetailVO.setSex("1");
                    } else if ("\u5973".equals(datas.get(2))) {
                        salaryDetailVO.setSex("2");
                    }
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(3)))) {
                    String teamName = ((String)datas.get(3)).trim();
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(ProjectTeamEntity::getName, (Object)teamName);
                    list = this.projectTeamService.list((Wrapper)wrapper);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        salaryDetailVO.setTeamId(String.valueOf(((ProjectTeamEntity)((Object)list.get(0))).getId()));
                        salaryDetailVO.setTeamName(((ProjectTeamEntity)((Object)list.get(0))).getName());
                    }
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(4)))) {
                    String workType = ((String)datas.get(4)).trim();
                    CommonResponse workerTypeListRes = this.defdocApi.getDefDocByDefCode("labor_worker_type");
                    if (workerTypeListRes.isSuccess()) {
                        List workerTypeList = (List)workerTypeListRes.getData();
                        for (DefdocDetailVO defdocDetailVO : workerTypeList) {
                            if (!defdocDetailVO.getName().equals(workType)) continue;
                            salaryDetailVO.setWorkType(String.valueOf(defdocDetailVO.getId()));
                            salaryDetailVO.setWorkTypeName(defdocDetailVO.getName());
                        }
                    } else {
                        errMsg.append("`\u5de5\u79cd\u67e5\u8be2\u5931\u8d25`");
                    }
                }
                salaryDetailVO.setBankName((String)datas.get(5));
                if (StringUtils.isNotBlank((String)((String)datas.get(6))) && !((String)datas.get(6)).matches(regex)) {
                    errMsg.append("`\u94f6\u884c\u5361\u53f7\u586b\u5199\u9519\u8bef`");
                }
                salaryDetailVO.setBankCard((String)datas.get(6));
                if (datas.get(7) != null) {
                    String wagesTypeName = (String)datas.get(7);
                    String wagesType = null;
                    if ("\u6309\u5c0f\u65f6\u8ba1\u7b97".equals(wagesTypeName)) {
                        wagesType = "1";
                    } else if ("\u6309\u65e5\u8ba1\u7b97".equals(wagesTypeName)) {
                        wagesType = "2";
                    } else if ("\u6309\u6708\u8ba1\u7b97".equals(wagesTypeName)) {
                        wagesType = "3";
                    } else if ("\u6309\u5de5\u7a0b\u91cf\u8ba1\u7b97".equals(wagesTypeName)) {
                        wagesType = "4";
                    }
                    salaryDetailVO.setWagesType(wagesType);
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(8)))) {
                    try {
                        salaryDetailVO.setPrice(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5de5\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u5de5\u4ef7\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(9)))) {
                    try {
                        salaryDetailVO.setActualCheckNum(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5b9e\u9645\u8003\u52e4\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u5b9e\u9645\u8003\u52e4\u4e3a\u5fc5\u586b\u9879`");
                }
                if (salaryDetailVO.getActualCheckNum() != null && salaryDetailVO.getPrice() != null) {
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)salaryDetailVO.getActualCheckNum(), (BigDecimal)salaryDetailVO.getPrice());
                    salaryDetailVO.setMny(mny);
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(11)))) {
                    try {
                        salaryDetailVO.setOvertimeMny(new BigDecimal((String)datas.get(11)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u52a0\u73ed\u5de5\u8d44\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(12)))) {
                    try {
                        salaryDetailVO.setDeductMny(new BigDecimal((String)datas.get(12)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u6263\u6b3e\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                salaryDetailVO.setErrorMessage(errMsg.toString());
                salaryDetailVO.setDeductReason((String)datas.get(13));
                BigDecimal shouldSalaryMny = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)salaryDetailVO.getMny(), (BigDecimal)salaryDetailVO.getOvertimeMny()), (BigDecimal)salaryDetailVO.getDeductMny());
                salaryDetailVO.setShouldSalaryMny(shouldSalaryMny);
                salaryDetailVO.setMemo((String)datas.get(15));
                QueryWrapper objectQueryWrapper = new QueryWrapper();
                objectQueryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                objectQueryWrapper.eq((Object)"id_card", (Object)salaryDetailVO.getIdCard());
                objectQueryWrapper.eq((Object)"project_id", (Object)projectId);
                objectQueryWrapper.orderByDesc((Object)"enter_date");
                list = this.workRecordService.list((Wrapper)objectQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    WorkRecordEntity entity = (WorkRecordEntity)((Object)list.get(0));
                    salaryDetailVO.setContractId(entity.getSubContractId());
                    salaryDetailVO.setContractName(entity.getSubContractName());
                    salaryDetailVO.setSupplierId(entity.getSupplierId());
                    salaryDetailVO.setSupplierName(entity.getSupplierName());
                    salaryDetailVO.setWorkerId(entity.getWorkerId());
                    salaryDetailVO.setPhone(entity.getPhone());
                    this.logger.info("\u8eab\u4efd\u8bc1\u53f7\u5339\u914d\u7684\u4fe1\u606f" + JSONObject.toJSONString((Object)((Object)entity)));
                    if (entity.getEnterDate() != null && entity.getExitDate() != null) {
                        String enterDate = EJCDateUtil.format(entity.getEnterDate(), "yyyy-MM-dd");
                        String exitDate = EJCDateUtil.format(entity.getExitDate(), "yyyy-MM-dd");
                        List<String> dayBetween = EJCDateUtil.getDayBetween(enterDate, exitDate);
                        salaryDetailVO.setSysCheckNum(Integer.valueOf(dayBetween.size()));
                    }
                    salaryDetailVO.setSource("1");
                } else {
                    salaryDetailVO.setSource("2");
                }
                if (StringUtils.isBlank((String)salaryDetailVO.getErrorMessage())) {
                    successList.add(salaryDetailVO);
                    continue;
                }
                errorList.add(salaryDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public Integer haveSalaryFlag(Long workerId, String exitDate) {
        return ((SalaryMapper)this.baseMapper).haveSalaryFlag(workerId, exitDate);
    }

    @Override
    public List<AttendanceVO> queryWorkerAttendanceList(Long workerId, String month, Long projectId, String createTime) {
        return ((SalaryMapper)this.baseMapper).queryWorkerAttendanceList(workerId, month, projectId, createTime);
    }

    @Override
    public List<SalaryVO> querySalaryPage(QueryWrapper wrapper, String salaryMonth, Page<SalaryVO> page) {
        return ((SalaryMapper)this.baseMapper).querySalaryPage(wrapper, salaryMonth, page);
    }
}

