/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.henger.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.enums.WorkerConsts;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.bean.HengErTaskEntity;
import com.ejianc.business.other.henger.service.HengErPersonApiService;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.business.other.henger.vo.HengErTaskVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"hengErTask"})
public class HengErTaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IHengErTaskService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private HengErPersonApiService hengErPersonApiService;
    @Autowired
    private IWorkRecordService workRecordService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HengErTaskVO> saveOrUpdate(@RequestBody HengErTaskVO saveOrUpdateVO) {
        HengErTaskEntity entity = (HengErTaskEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, HengErTaskEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        HengErTaskVO vo = (HengErTaskVO)BeanMapper.map((Object)((Object)entity), HengErTaskVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<HengErTaskVO> queryDetail(Long id) {
        HengErTaskEntity entity = (HengErTaskEntity)((Object)this.service.selectById(id));
        HengErTaskVO vo = (HengErTaskVO)BeanMapper.map((Object)((Object)entity), HengErTaskVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HengErTaskVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (HengErTaskVO hengErTaskVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<HengErTaskVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), HengErTaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("HengErTask-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refHengErTaskData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<HengErTaskVO>> refHengErTaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), HengErTaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/resetByTaskId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<String>> resetTask(@RequestBody List<HengErTaskVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        ArrayList<String> errorList = new ArrayList<String>();
        if (ListUtil.isNotEmpty(ids)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List taskEntities = this.service.queryList(queryParam);
            for (HengErTaskEntity taskEntity : taskEntities) {
                if (taskEntity.getServiceType().equals(ServiceTypeEnum.\u5355\u4e2a\u540d\u5355\u6dfb\u52a0.getStatus())) {
                    WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.selectById(taskEntity.getServiceId()));
                    if (workRecordEntity == null) {
                        errorList.add("\u4efb\u52a1Id[" + taskEntity.getTaskId() + "]\u4e2d,\u4eba\u5458\u4e0d\u5b58\u5728!");
                        this.logger.error("\u4efb\u52a1Id[" + taskEntity.getTaskId() + "]\u4e2d,\u4eba\u5458\u4e0d\u5b58\u5728!");
                    }
                    if (workRecordEntity.getEnterExitState() != WorkerConsts.WorkStateEnum.\u5df2\u5165\u573a.getCode()) {
                        errorList.add("\u4efb\u52a1Id[" + taskEntity.getTaskId() + "]\u4e2d," + workRecordEntity.getName() + "\u4eba\u5458\u4e0d\u5728\u573a!");
                        this.logger.error("\u4efb\u52a1Id[" + taskEntity.getTaskId() + "]\u4e2d," + workRecordEntity.getName() + "\u4eba\u5458\u4e0d\u5728\u573a!");
                    }
                    WorkRecordVO workRecordVO = (WorkRecordVO)BeanMapper.map((Object)((Object)workRecordEntity), WorkRecordVO.class);
                    JSONObject serviceRequest = this.hengErPersonApiService.getAddCom(workRecordVO, taskEntity.getEquipSn());
                    this.service.addTaskByType(taskEntity.getEquipSn(), taskEntity.getServiceId(), taskEntity.getServiceType(), serviceRequest.toJSONString());
                    continue;
                }
                if (taskEntity.getServiceType().equals(ServiceTypeEnum.\u5355\u4e2a\u540d\u5355\u5220\u9664.getStatus())) {
                    this.service.addTaskByType(taskEntity.getEquipSn(), taskEntity.getServiceId(), taskEntity.getServiceType(), taskEntity.getQueryParam());
                    continue;
                }
                if (!taskEntity.getServiceType().equals(ServiceTypeEnum.\u591a\u4e2a\u540d\u5355\u67e5\u8be2.getStatus())) continue;
                this.service.addTaskByType(taskEntity.getEquipSn(), taskEntity.getServiceId(), taskEntity.getServiceType(), taskEntity.getQueryParam());
            }
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u6dfb\u52a0\u6210\u529f\uff01", errorList);
    }

    @RequestMapping(value={"/searchPersonListTask"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> searchPersonListTask(String equipSn, Integer beginNO) {
        JSONObject queryParam = this.hengErPersonApiService.getSearchPersonListCom(equipSn, beginNO);
        this.service.addTaskByType(equipSn, null, ServiceTypeEnum.\u591a\u4e2a\u540d\u5355\u67e5\u8be2.getStatus(), queryParam.toJSONString());
        return CommonResponse.success((String)"\u4efb\u52a1\u6dfb\u52a0\u6210\u529f\uff01\u66f4\u65b0\u6570\u636e\u67095\u5206\u949f\u5ef6\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8fdb\u884c\u67e5\u770b\uff01");
    }

    @RequestMapping(value={"/searchPersonTask"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> searchPersonTask(String equipSn, Long workerId, Long equipPersonId) {
        JSONObject queryParam = this.hengErPersonApiService.getSearchPersonCom(equipSn, workerId);
        this.service.addTaskByType(equipSn, equipPersonId, ServiceTypeEnum.\u5355\u4e2a\u540d\u5355\u67e5\u8be2.getStatus(), queryParam.toJSONString());
        return CommonResponse.success((String)"\u4efb\u52a1\u6dfb\u52a0\u6210\u529f\uff01\u66f4\u65b0\u6570\u636e\u67095\u5206\u949f\u5ef6\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8fdb\u884c\u67e5\u770b\uff01");
    }

    @RequestMapping(value={"/addPersonTask"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateEquipPersonById(String equipSn, Long workRecordId) {
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.selectById(workRecordId));
        WorkRecordVO vo = (WorkRecordVO)BeanMapper.map((Object)((Object)workRecordEntity), WorkRecordVO.class);
        JSONObject queryParam = this.hengErPersonApiService.getAddCom(vo, equipSn);
        this.service.addTaskByType(equipSn, workRecordId, ServiceTypeEnum.\u5355\u4e2a\u540d\u5355\u6dfb\u52a0.getStatus(), queryParam.toJSONString());
        return CommonResponse.success((String)"\u4efb\u52a1\u6dfb\u52a0\u6210\u529f\uff01\u66f4\u65b0\u6570\u636e\u67095\u5206\u949f\u5ef6\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8fdb\u884c\u67e5\u770b\uff01");
    }
}

