package com.ejianc.business.other.henger.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.henger.mapper.HengErEquipMapper;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;

import java.util.List;

/**
 * 恒尔-设备
 * 
 * @author generator
 * 
 */
@Service("hengErEquipService")
public class HengErEquipServiceImpl extends BaseServiceImpl<HengErEquipMapper, HengErEquipEntity> implements IHengErEquipService{
    @Override
    public HengErEquipVO selectByEquipSn(String equipSn) {

        QueryWrapper<HengErEquipEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("equip_sn",equipSn);
        List<HengErEquipEntity> list = this.list(queryWrapper);
        if(ListUtil.isNotEmpty(list)){
            return BeanMapper.map(list.get(0), HengErEquipVO.class);
        }
        return null;
    }
}
