package com.ejianc.business.labor.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.desktop.vo.TypeVO;
import com.ejianc.business.labor.vo.AttendanceVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用工记录
 * 
 * @author generator
 * 
 */
@Mapper
public interface WorkRecordMapper extends BaseCrudMapper<WorkRecordEntity> {

    /**
     * @description: 根据班组id改变劳务员工所属班组名称
     * 班组档案修改名称时，劳务员工冗余的所属班组名称没有变化
     * @param teamId 更新此班组下的所有劳务员工的teamname，适用班组名字更新
     * @param workerId 更新此劳务工人的teamname， 需要前置步骤把teamid放对先更新了
     * @return
     * @author songlx
     * @date: 2022/11/28
     */
    Integer updateWorkerTeamNameByTeamIdOrWorkerId(@Param("teamId") Long teamId, @Param("workerId") Long workerId);


    /**
     * 根据传递的字段进行分组统计
     * @param groupCode
     * @param groupName
     * @param wrapper
     * @return
     */
    List<TypeVO> queryUserTypeByGroupCode(@Param("groupCode") String groupCode,
                                          @Param("groupName") String groupName,
                                          @Param(Constants.WRAPPER) QueryWrapper<WorkRecordEntity> wrapper);
}
