package com.ejianc.business.labor.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.AttendancePerLineVO;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.vo.AttendanceDailyExportVO;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 考勤记录
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Mapper
public interface AttendanceMapper extends BaseCrudMapper<AttendanceEntity> {

	/**
	 * 按个人统计分页查询
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @param startDate
     * @param endDate
     * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, @Param(Constants.WRAPPER) QueryWrapper<AttendanceEntity> wrapper, @Param("startDate") String startDate,@Param("endDate") String endDate);

	/**
	 * 根据组织id 查询累计出勤天数
	 * @param orgIds
	 * @return
	 */
	Integer queryAttendanceOrgIds(@Param("orgIds") String orgIds);


	/**
	 * 分页查询当天考勤记录（包含未考勤人员）
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceVO> queryDailyAttendancePage(Page<AttendanceVO> p, @Param(Constants.WRAPPER) QueryWrapper<AttendanceVO> wrapper);


	/**
	 * 查询当天考勤记录（包含未考勤人员）
	 *
	 * @param wrapper 条件构造器
	 *
	 * <{@link AttendanceEntity}>
	 */
	List<AttendanceVO> queryDailyAttendanceList(@Param(Constants.WRAPPER) QueryWrapper<AttendanceVO> wrapper);

	/**
	 * 分页查询所有历史考勤记录（包含未考勤人员）
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceVO> queryAllAttendanceRecord(Page<AttendanceVO> p,@Param(Constants.WRAPPER) QueryWrapper<AttendanceVO> wrapper);


	/**
	 * 门户-按时间查询考勤率
	 *
	 * @param wrapper 条件构造器
	 *
	 * <{@link AttendanceEntity}>
	 */
	List<AttendancePerLineVO> queryAttendancePerLine(@Param(Constants.WRAPPER) QueryWrapper<AttendanceVO> wrapper);

	/**
	 * 考勤每日统计导出报表
	 *
	 * @param wrapper 条件构造器
	 *
	 */
	List<AttendanceDailyExportVO> queryDailyAttendanceExport(@Param(Constants.WRAPPER) QueryWrapper<AttendanceDailyExportVO> wrapper);


}
