package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.AttendancePerLineVO;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 考勤记录
 *
 * @author generator
 */
public interface IAttendanceService extends IBaseService<AttendanceEntity> {

	int totalAttendanceDays(Date enterDate, Date exitDate, Long workerId, Long projectId);

	/**
	 * 按个人统计分页查询
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @param startDate
     * @param endDate
     * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, QueryWrapper<AttendanceEntity> wrapper, String startDate, String endDate);


	Integer queryAttendanceOrgIds(String orgIds);

	/**
	 * 分页查询当天考勤记录（包含未考勤人员）
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceVO> queryDailyAttendancePage(Page<AttendanceVO> p, QueryWrapper<AttendanceVO> wrapper);


	/**
	 * 查询当天考勤记录（包含未考勤人员）
	 *
	 * @param wrapper 条件构造器
	 *
	 * <{@link AttendanceEntity}>
	 */
	List<AttendanceVO> queryDailyAttendanceList(QueryWrapper<AttendanceVO> wrapper);
	/**
	 * 分页查询所有历史考勤记录（包含未考勤人员）
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceVO> queryAllAttendanceRecord(Page<AttendanceVO> p,QueryWrapper<AttendanceVO> wrapper);

	/**
	 * 门户-按时间查询考勤率
	 *
	 * @param wrapper 条件构造器
	 *
	 * <{@link AttendanceEntity}>
	 */
	List<AttendancePerLineVO> queryAttendancePerLine(QueryWrapper<AttendanceVO> wrapper);

	/**
	 * 考勤每日统计导出报表
	 *
	 * @param param
	 *
	 */
     JSONObject queryDailyAttendanceExport(QueryParam param);

}
