package com.ejianc.business.labor.service;

import com.ejianc.business.labor.vo.IdentityCardInfoVO;

/**
 * 身份证ocr识别接口
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public interface IIdCardService {

	/**
	 * 校验身份证以及身份证信息识别
	 *
	 * @param imageUrl 身份证阿里oss存储在线地址
	 * @param side     face：人像面  back：国徽面
	 *
	 * @return {@link IdentityCardInfoVO}
	 */
	IdentityCardInfoVO checkAndRecognizeIdentityCardInfo(String imageUrl, String side);

}
