package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.base.bean.BaseTeamEntity;
import com.ejianc.business.base.service.IBaseTeamService;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.ProjectTeamRecordsEntity;
import com.ejianc.business.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.labor.mapper.ProjectTeamMapper;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.vo.PorjectVO;
import com.ejianc.business.labor.vo.ProjectTeamVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目班组
 *
 * @author generator
 */
@Service("projectTeamService")
public class ProjectTeamServiceImpl extends BaseServiceImpl<ProjectTeamMapper, ProjectTeamEntity> implements IProjectTeamService {

    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";//此处需要根据实际修改
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ProjectTeamMapper projectTeamMapper;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IWorkerEnterService enterService;
//    @Autowired
//    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IPorjectService porjectService;
    @Autowired
    private IProjectTeamRecordsService teamRecordsService;
    @Autowired
    private IBaseTeamService baseTeamService;

    @Autowired
    private IRoleService roleService;

    @Override
    public ProjectTeamVO insertOrUpdate(ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectTeamEntity.class);
        boolean updateFlag = false;
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            /**
             * 插入一条入场记录
             */
            ProjectTeamRecordsEntity teamRecords = new ProjectTeamRecordsEntity();
            teamRecords.setSourceId(entity.getId());
            teamRecords.setOrgName(entity.getName());
            teamRecords.setSourceType(entity.getSourceType());
            teamRecords.setServiceDate(new Date());
            teamRecords.setTeamStatus("进场");
            teamRecords.setProjectId(entity.getProjectId());
            teamRecords.setProjectName(entity.getProjectName());
            teamRecordsService.saveOrUpdate(teamRecords);
            entity.setServiceStatus("进场");




            /**
             * 自动插入班组信息
             */
            if(entity.getSourceId() == null){
                BillCodeParam baseTeamBillCodeParam = BillCodeParam.build("Invoice_Open_Apply_Code", InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> baseTeamBillCode = billCodeApi.generateBillCode(baseTeamBillCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                BaseTeamEntity baseTeamEntity = new BaseTeamEntity();
                baseTeamEntity.setBillCode(baseTeamBillCode.getData());
                baseTeamEntity.setTeamName(entity.getName());
                baseTeamEntity.setProjectId(entity.getProjectId());
                baseTeamEntity.setProjectName(entity.getProjectName());
                baseTeamEntity.setSourceType(entity.getSourceType());
                baseTeamEntity.setResponsiblePersonIdCardType(entity.getPmIdCardType());
                baseTeamEntity.setResponsiblePersonIdCardTypeCode(entity.getPmIdCardTypeCode());
                baseTeamEntity.setResponsiblePersonIdCardTypeCodeName(entity.getPmIdCardTypeName());
                baseTeamEntity.setResponsiblePersonIdNumber(entity.getPmIdCardNumber());
                baseTeamEntity.setResponsiblePersonName(entity.getPmName());
                baseTeamEntity.setResponsiblePersonPhone(entity.getPmPhone());
                baseTeamEntity.setOrgId(entity.getOrgId());
                baseTeamEntity.setOrgName(entity.getOrgName());
                baseTeamEntity.setId(IdWorker.getId());
                baseTeamService.saveOrUpdate(baseTeamEntity);

                //回填id
                entity.setSourceId(baseTeamEntity.getId());
            }

        } else {
            ProjectTeamEntity entity1 = super.selectById(entity.getId());
            if (!entity.getName().equals(entity1.getName())) {
                updateFlag = true;
            }
        }
        if (entity.getSourceFlag() == null) {
            entity.setSourceFlag(0);
        }
        //设置是否是末级
        LambdaQueryWrapper<ProjectTeamEntity> wrapperByParentId = new LambdaQueryWrapper<>();
        wrapperByParentId.eq(entity.getId() != null, ProjectTeamEntity::getParentId, entity.getId());
        wrapperByParentId.eq(ProjectTeamEntity::getTenantId, InvocationInfoProxy.getTenantid());
        int count = super.count(wrapperByParentId);
        if (count > 0) {
            entity.setIsLeaf(false);
        } else {
            entity.setIsLeaf(true);
        }
        ProjectTeamEntity pEntity = selectById(entity.getParentId());
        entity.setInnerCode(pEntity.getInnerCode() + "|" + entity.getId());
        entity.setInnerCodeName(pEntity.getInnerCodeName() + "|" + entity.getName());
        super.saveOrUpdate(entity, false);
        Long parentId = entity.getParentId();
        if (parentId != null) {
            LambdaUpdateWrapper<ProjectTeamEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ProjectTeamEntity::getIsLeaf, false);
            wrapper.eq(ProjectTeamEntity::getId, parentId);
            super.update(wrapper);
        }
        if (updateFlag) {
            updateWorkerTeamNameByTeamIdOrWorkerId(entity.getId(), null);
        }
        ProjectTeamVO vo = BeanMapper.map(entity, ProjectTeamVO.class);
        return vo;
    }


    /**
     * 引入班组逻辑
     * 引入班组时，查询公司班组树。根节点不可选中，其他节点都可选。已经引入的班组不可再次引入；
     * 当第一次只引入子级，下次引入父级时，需要按公司班组构造树形；
     *
     * @param voList
     * @return
     */
    @Override
    public List<String> insertBatch(List<ProjectTeamVO> voList) {
        List<String> errorMsg = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(voList)) {
            Long projectId = voList.get(0).getProjectId();
            if (null != projectId) {
//                CommonResponse<ProjectRegisterVO> projectDetail = projectApi.queryProjectDetail(projectId);
//                CommonResponse<ProjectVO> projectDetail = projectPoolApi.queryDetailById(projectId);
//
//                if (!projectDetail.isSuccess()) {
//                    throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
//                }
//                ProjectVO project = projectDetail.getData();
                PorjectEntity project = porjectService.selectById(projectId);
                //获取 项目根班组
                QueryWrapper<ProjectTeamEntity> queryProject = new QueryWrapper<>();
                queryProject.eq("project_id", project.getId());
                queryProject.isNull("parent_id");
                ProjectTeamEntity projectTeamEntity = super.getOne(queryProject);
                List<ProjectTeamEntity> saveEntity = new ArrayList<>();
                for (ProjectTeamVO vo : voList) {
                    //根据班组去查询是否存在
                    LambdaQueryWrapper<ProjectTeamEntity> lambda = new LambdaQueryWrapper<>();
                    lambda.eq(ProjectTeamEntity::getSourceOrgTeamId, vo.getSourceOrgTeamId());
                    lambda.eq(ProjectTeamEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    lambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
                    lambda.eq(ProjectTeamEntity::getProjectId, project.getId());
                    int count = super.count(lambda);
                    if (count > 0) {
                        //提示当前不能插入已存在
                        errorMsg.add("当前" + vo.getName() + "已存在");
                    } else {
                        ProjectTeamEntity entity = BeanMapper.map(vo, ProjectTeamEntity.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), vo);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (!billCode.isSuccess()) {
                            errorMsg.add("网络异常， 编码生成失败， 请稍后再试");
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        entity.setId(IdWorker.getId());
                        entity.setProjectId(project.getId());
//                        entity.setProjectName(project.getName());
                        entity.setProjectName(project.getName());
                        entity.setOrgId(project.getOrgId());
                        entity.setParentOrgId(project.getOrgId());
                        entity.setParentOrgName(project.getOrgName());
                        entity.setCode(billCode.getData());
                        /**
                         * 插入一条入场记录
                         */
                        ProjectTeamRecordsEntity teamRecords = new ProjectTeamRecordsEntity();
                        teamRecords.setSourceId(entity.getId());
                        teamRecords.setOrgName(entity.getName());
                        teamRecords.setSourceType(entity.getSourceType());
                        teamRecords.setServiceDate(new Date());
                        teamRecords.setTeamStatus("进场");
                        teamRecords.setProjectId(entity.getProjectId());
                        teamRecords.setProjectName(entity.getProjectName());
                        teamRecordsService.saveOrUpdate(teamRecords);
                        entity.setServiceStatus("进场");


                        //设置父级 根据当前单据 的sourceParentId 查询是否存在父班组
                        QueryWrapper<ProjectTeamEntity> queryWrapper = new QueryWrapper<>();
                        queryWrapper.eq("source_org_team_id", entity.getSourceParentId());
                        queryWrapper.eq("project_id", project.getId());

                        ProjectTeamEntity one = super.getOne(queryWrapper);
                        if (one != null) {
                            entity.setParentId(one.getId());
                            one.setIsLeaf(false);
                            super.saveOrUpdate(one);
                            entity.setInnerCode(one.getInnerCode() + "|" + entity.getId());
                            entity.setInnerCodeName(one.getInnerCodeName() + "|" + entity.getName());
                        } else {
                            // 绑定到根节点
                            entity.setParentId(projectTeamEntity.getId());
                            entity.setInnerCode(projectTeamEntity.getInnerCode() + "|" + entity.getId());
                            entity.setInnerCodeName(projectTeamEntity.getInnerCodeName() + "|" + entity.getName());
                        }
                        //判断是否存在子级
                        QueryWrapper<ProjectTeamEntity> childQuery = new QueryWrapper<>();
                        childQuery.eq("source_parent_id", entity.getSourceOrgTeamId());
                        childQuery.eq("project_id", project.getId());
                        List<ProjectTeamEntity> list = super.list(childQuery);
                        if (CollectionUtils.isNotEmpty(list)) {
                            for (ProjectTeamEntity upEntity : list) {
                                upEntity.setParentId(entity.getId());
                                upEntity.setInnerCode(entity.getInnerCode() + "|" + upEntity.getId());
                                upEntity.setInnerCodeName(entity.getInnerCodeName() + "|" + upEntity.getName());

                                /**
                                 * 更改末级节点的innerCode
                                 */
                                QueryWrapper<ProjectTeamEntity> thirdChildQuery = new QueryWrapper<>();
                                thirdChildQuery.eq("source_parent_id", upEntity.getSourceOrgTeamId());
                                thirdChildQuery.eq("project_id", project.getId());
                                List<ProjectTeamEntity> thirdList = super.list(thirdChildQuery);
                                if(CollectionUtils.isNotEmpty(thirdList)){
                                    for (ProjectTeamEntity teamEntity : thirdList) {
                                        teamEntity.setInnerCode(entity.getInnerCode() + "|" + upEntity.getId() + "|" + teamEntity.getId());
                                        teamEntity.setInnerCodeName(entity.getInnerCodeName() + "|" + upEntity.getName() + "|" + teamEntity.getName());
                                    }
                                    super.saveOrUpdateBatch(thirdList);
                                }

                            }
                            super.saveOrUpdateBatch(list);
                            entity.setIsLeaf(false);
                        } else {
                            entity.setIsLeaf(true);
                        }
                        entity.setTenantId(InvocationInfoProxy.getTenantid());
                        super.saveOrUpdate(entity);
                        saveEntity.add(entity);

                    }
                }
            } else {
                errorMsg.add("当前项目为空");

            }
        } else {
            errorMsg.add("当前为空");

        }
        return errorMsg;

    }

    /**
     * 修改班组名称
     */
    Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        Integer integer = recordService.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, null);
        Integer integer1 = enterService.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, null);
        return integer + integer1;
    }
}
