package com.ejianc.business.labor.utils;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 模拟登录
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Component
public class MockLogin {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Value("${common.env.base-host}")
	private String BASE_HOST; // 域名

	public String login(Long tenantId) {
		String authority = "";
		String url = BASE_HOST + "ejc-idm-web/user/context/getBytenantid";

		Map<String, Object> params = new HashMap<>();
		params.put("tenantId", tenantId);

		HttpResponse response = HttpUtil.createGet(url)
				.form(params).execute();
		if (!response.isOk()) {
			throw new BusinessException("模拟登录失败！");
		}

		String body = response.body();
		JSONObject jsonObject = JSON.parseObject(body);
		if (jsonObject.get("data") != null) {
			JSONObject data = (JSONObject) jsonObject.get("data");
			logger.info("模拟登录data-{}", JSON.toJSONString(data, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			if (data.get("userContext") != null) {
				JSONObject userContext = (JSONObject) data.get("userContext");
				authority = "userType=" + userContext.getString("userType") + ";userCode="
						+ userContext.getString("userCode") +
						";orgId=" + userContext.getString("orgId") +
						";tenantid=" + userContext.getString("tenantid") + ";token="
						+ userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
						+ ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
						+ userContext.getString("userId");
			}
		}
		return authority;
	}
}
