/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendance"})
public class AttendanceController
implements Serializable {
    private static final long serialVersionUID = 3843428190950238299L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IAttendanceService service;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<AttendanceVO> saveOrUpdate(@RequestBody AttendanceVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        AttendanceEntity entity = (AttendanceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AttendanceEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        AttendanceVO vo = (AttendanceVO)BeanMapper.map((Object)((Object)entity), AttendanceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<AttendanceVO> queryDetail(Long id) {
        AttendanceEntity entity = (AttendanceEntity)((Object)this.service.selectById(id));
        AttendanceVO vo = (AttendanceVO)BeanMapper.map((Object)((Object)entity), AttendanceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<AttendanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AttendanceVO attendanceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryPageByPerson"})
    public CommonResponse<IPage<AttendanceVO>> queryPageByPerson(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map params = param.getParams();
        String startDate = null;
        String endDate = null;
        if (params.containsKey("punchCardDate") && params.get("punchCardDate") != null) {
            Parameter punchCardDate = (Parameter)params.get("punchCardDate");
            Object punchCardDateStr = punchCardDate.getValue();
            String[] dateArr = punchCardDateStr.toString().split(",");
            startDate = dateArr[0];
            endDate = dateArr[1];
            params.remove("punchCardDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage<AttendanceEntity> page = this.service.queryPageByPerson((Page<AttendanceEntity>)p, (QueryWrapper<AttendanceEntity>)wrapper, startDate, endDate);
        List pageRecords = page.getRecords();
        List records = BeanMapper.mapList((Iterable)pageRecords, AttendanceVO.class);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        result.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"/queryPageByRecord"})
    public CommonResponse<IPage<AttendanceVO>> queryPageByRecord(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByDesc((Object[])new String[]{"punch_card_date", "create_time", "name"});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)wrapper);
        List pageRecords = page.getRecords();
        List records = BeanMapper.mapList((Iterable)pageRecords, AttendanceVO.class);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        result.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"excelExportByPerson"})
    public void excelExportByPerson(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map params = param.getParams();
        String startDate = null;
        String endDate = null;
        if (params.containsKey("punchCardDate") && params.get("punchCardDate") != null) {
            Parameter punchCardDate = (Parameter)params.get("punchCardDate");
            Object punchCardDateStr = punchCardDate.getValue();
            String[] dateArr = punchCardDateStr.toString().split(",");
            startDate = dateArr[0];
            endDate = dateArr[1];
            params.remove("punchCardDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage<AttendanceEntity> page = this.service.queryPageByPerson((Page<AttendanceEntity>)p, (QueryWrapper<AttendanceEntity>)wrapper, startDate, endDate);
        List list = BeanMapper.mapList((Iterable)page.getRecords(), AttendanceVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AttendancePerson-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportByRecord"})
    public void excelExportByRecord(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByDesc((Object[])new String[]{"punch_card_date", "create_time", "name"});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)wrapper);
        List list = BeanMapper.mapList((Iterable)page.getRecords(), AttendanceVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttendanceVO attendanceVO;
                attendanceVO.setRemoteFlagName((attendanceVO = (AttendanceVO)iterator.next()).getRemoteFlag() != null && attendanceVO.getRemoteFlag() == 0 ? "\u5426" : "\u662f");
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("AttendanceRecord-export.xlsx", beans, response);
    }

    @GetMapping(value={"/refAttendanceData"})
    public CommonResponse<IPage<AttendanceVO>> refAttendanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AttendanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/queryDailyAttendanceExportPage"})
    public CommonResponse<JSONObject> queryDailyAttendanceExportPage(@RequestBody QueryParam param) {
        DateTime endDate;
        UserContext userContextCache = this.sessionManager.getUserContext();
        Integer orgType = userContextCache.getOrgType();
        if (orgType != 5) {
            throw new BusinessException("\u8bf7\u5728\u9879\u76ee\u5c42\u7ea7\u8fdb\u884c\u8bbf\u95ee!");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (!param.getParams().containsKey("punchCardDate")) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\uff01");
        }
        String punchCardDate = ((Parameter)param.getParams().get("punchCardDate")).getValue().toString();
        String[] dates = punchCardDate.split(",");
        if (dates.length != 2) {
            throw new BusinessException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        DateTime startDate = DateUtil.parseDate((String)dates[0]);
        long between = DateUtil.between((Date)startDate, (Date)(endDate = DateUtil.parseDate((String)dates[1])), (DateUnit)DateUnit.DAY);
        if (between > 31L) {
            throw new BusinessException("\u8d85\u8fc7\u65e5\u671f\u7b5b\u9009\u8303\u56f4\uff0c\u6700\u591a\u67e5\u8be231\u5929!");
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("startWorkPlace");
        fuzzyFields.add("endWorkPlace");
        JSONObject jsonObject = this.service.queryDailyAttendanceExport(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }
}

